/** 
 * @file    kSvLight.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_LIGHT_X_H
#define K_FIRESYC_SERVER_LIGHT_X_H

typedef struct kSvLightPrimeBackup
{
    kLightControl controlType; 
    kSize controlId; 
    kArrayList extensions; 
    k64u delay; 
    k64u exposure; 
    k64u gap; 
    k64u leadIn; 
    k64u totalLeadIn; 
    k64u leadOut; 
    k64u totalLeadOut;
} kSvLightPrimeBackup;

typedef struct kSvLightClass
{
    kObjectClass base; 
    
    kSvNode node;                   //Server node (parent). 
    kHxLight hwLight;               //Hardware light (kHxLight).
  
    k64f maxDutyCycle;              //Max duty cycle setting (percentage).

    kLightPrimingMode primingMode;      //Priming mode setting.
    kLightCouplingMode couplingMode;    //Coupling mode setting.

    kPxBlock block;                 //Input block to provide data to pipe. 

    kSvLightPrimeBackup primeBackup;   //settings backup; used when priming hardware to run

} kSvLightClass; 

kDeclareClassEx(kFs, kSvLight, kObject)
        
kFsFx(kStatus) kSvLight_Init(kSvLight light, kType type, kSvNode node, kHxLight hwLight, kAlloc alloc);
kFsFx(kStatus) kSvLight_VRelease(kSvLight light);

kFsFx(kStatus) kSvLight_FormatStates(kSvLight light, kXml xml, kXmlItem item);
kFsFx(kStatus) kSvLight_FormatExtensions(kSvLight light, kXml xml, kXmlItem item);

kFsFx(kStatus) kSvLight_ParseStates(kSvLight light, kXml xml, kXmlItem item);
kFsFx(kStatus) kSvLight_ParseExtensions(kSvLight light, kXml xml, kXmlItem item);

kFsFx(kStatus) kSvLight_UpdateBlock(kSvLight light);

kFsFx(kStatus) kSvLight_OnInputData(kSvLight light, kPxPort port, kMsgInfo message);

#endif
