/** 
 * @file    kSvSerialOut.h
 * @brief   Declares the kSvSerialOut class and related types. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_SERIAL_OUT_H
#define K_FIRESYC_SERVER_SERIAL_OUT_H

#include <kFireSync/Server/kSvDef.h>

/**
 * @internal
 * @class       kSvSerialOut
 * @extends     kObject
 * @ingroup     kFireSync-Server-Devices
 * @brief       Lightweight server wrapper for kHxSerialOut. 
 */
//typedef kObject kSvSerialOut;          --forward-declared in kFsDef.x.h

/** 
 * Constructs a kSvSerialOut object.
 *
 * @public              @memberof kSvSerialOut
 * @param   serial      Destination for the constructed object handle. 
 * @param   node        Server node (parent). 
 * @param   hwSerial    Serial hardware driver handle. 
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) kSvSerialOut_Construct(kSvSerialOut* serial, kSvNode node, kHxSerialOut hwSerial, kAlloc allocator);

#include <kFireSync/Server/Devices/kSvSerialOut.x.h>

#endif
