/** 
 * @file    kSvControl.h
 * @brief   Declares the kSvControl class and related types. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_CONTROL_H
#define K_FIRESYC_SERVER_CONTROL_H

#include <kFireSync/Server/kSvDef.h>
#include <kApi/Io/kNetwork.h>

/**
 * @internal
 * @class   kSvControl
 * @extends kObject
 * @ingroup kFireSync-Server-Network
 * @brief   Represents an FCP-6 server.
 */
//typedef kObject kSvControl;      --forward-declared in kFsDef.x.h
 
/** 
 * Constructs a kSvControl object.
 *
 * @public              @memberof kSvControl
 * @param   control     Destination for the constructed object handle. 
 * @param   node        Parent/owner.  
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) kSvControl_Construct(kSvControl* control, kSvNode node, kAlloc allocator);

kFsFx(kStatus) kSvControl_SetLocalEndPoint(kSvControl control, kIpAddress address, k32u port);
kFsFx(kIpEndPoint) kSvControl_LocalEndPoint(kSvControl control);

kFsFx(kStatus) kSvControl_StartService(kSvControl control);
kFsFx(kStatus) kSvControl_StopService(kSvControl control);

#include <kFireSync/Server/Network/kSvControl.x.h>

#endif
