/** 
 * @file    kSvDataOutApp.h
 * @brief   Declares the kSvDataOutApp class and related types. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_DATA_OUT_APP_H
#define K_FIRESYC_SERVER_DATA_OUT_APP_H

#include <kFireSync/Server/kSvDef.h>

/**
 * @internal
 * @class   kSvDataOutApp
 * @extends kSvDataOutChannel
 * @ingroup kFireSync-Server-Network
 * @brief   Represents the server side of a local data connection (supports kSvNode implementation of kNodeProvider). 
 */
//typedef kSvDataOutChannel kSvDataOutApp;      --forward-declared in kFsDef.x.h
 
/** 
 * Constructs a kSvDataOutApp object.
 *
 * @public                  @memberof kSvDataOutApp
 * @param   channel         Destination for the constructed object handle. 
 * @param   service         Data output service (parent). 
 * @param   ports           List of block ports to receive. 
 * @param   portCount       Count of ports. 
 * @param   function        Callback function to receive messages. 
 * @param   receiver        Context for receive callback.  
 * @param   allocator       Memory allocator (or kNULL for default). 
 * @return                  Operation status. 
 */
kFsFx(kStatus) kSvDataOutApp_Construct(kSvDataOutApp* channel, kSvDataOut service, const k16u* ports, kSize portCount,
                                       kCallbackFx function, kPointer receiver, kAlloc allocator);

#include <kFireSync/Server/Network/kSvDataOutApp.x.h>

#endif
