/** 
 * @file    kSvDataOutApp.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_DATA_OUT_APP_X_H
#define K_FIRESYC_SERVER_DATA_OUT_APP_X_H

#include <kFireSync/Server/Network/kSvDataOutChannel.h>

typedef struct kSvDataOutAppClass
{
    kSvDataOutChannelClass base; 
    
    kCallback sendFx;               //Listener. 

} kSvDataOutAppClass; 

kDeclareClassEx(kFs, kSvDataOutApp, kSvDataOutChannel)
        
kFsFx(kStatus) kSvDataOutApp_Init(kSvDataOutApp channel, kType type, kSvDataOut service, const k16u* ports, kSize portCount, 
                                       kCallbackFx function, kPointer receiver, kAlloc alloc); 
kFsFx(kStatus) kSvDataOutApp_VRelease(kSvDataOutApp channel);

kFsFx(kStatus) kSvDataOutApp_VSend(kSvDataOutApp channel, kMsgInfo message);
kFsFx(kStatus) kSvDataOutApp_VEndSession(kSvDataOutApp channel); 

#endif
