/** 
 * @file    kSvDataOutNet.h
 * @brief   Declares the kSvDataOutNet class and related types. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_DATA_OUT_NET_H
#define K_FIRESYC_SERVER_DATA_OUT_NET_H

#include <kFireSync/Server/kSvDef.h>

/**
 * @internal
 * @class   kSvDataOutNet
 * @extends kSvDataOutChannel
 * @ingroup kFireSync-Server-Network
 * @brief   Represents the server side of an FDSP-6 connection.
 */
//typedef kSvDataOutChannel kSvDataOutNet;      --forward-declared in kFsDef.x.h
 
/** 
 * Constructs a kSvDataOutNet object.
 *
 * @public                  @memberof kSvDataOutNet
 * @param   channel         Destination for the constructed object handle. 
 * @param   service         Data output service (parent). 
 * @param   client          Client connection.
 * @param   maxQueueSize    Maximum output message queue size (bytes). 
 * @param   maxQueueCount   Maximum output message queue item count. 
 * @param   allocator       Memory allocator (or kNULL for default). 
 * @return                  Operation status. 
 */
kFsFx(kStatus) kSvDataOutNet_Construct(kSvDataOutNet* channel, kSvDataOut service, kTcpClient client, kSize maxQueueSize, kSize maxQueueCount, 
                                       kThreadPriorityClass priorityClass, k32s priorityOffset, kBitArray affinity,  kAlloc allocator);

kFsFx(kStatus) kSvDataOutNet_RemoteEndPoint(kSvDataOutNet channel, kIpEndPoint* remoteEndPoint);

#include <kFireSync/Server/Network/kSvDataOutNet.x.h>

#endif
