/** 
 * @file    kSvDataOutNet.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_DATA_OUT_NET_X_H
#define K_FIRESYC_SERVER_DATA_OUT_NET_X_H

#include <kFireSync/Server/Network/kSvDataOutChannel.h>

#define kSV_DATA_OUT_NET_QUIT_QUERY_PERIOD           (100000)        ///< Polling interval for quit (stop) status (us). 

typedef struct kSvDataOutNetClass
{
    kSvDataOutChannelClass base; 
    
    kTcpClient client;              //Client connection. 
    kSerializer serializer;         //Message serializer. 
    kIpEndPoint remoteEndPoint;     //Remote address information (useful for debugging). 

    kThread thread;                 //Thread to service client.

    kMsgQueue messageQueue;         //Messages to be sent -- kMsgQueue<kMsgInfo>. 

    kAtomic32s shouldQuit;          //Is the channel stopping?
    kAtomic32s hasExited;           //Is the channel still accepting commands?
    kAtomic32s isStalled;           //Has the channel stalled (tx timeout)?

    k64u lastMessageIndex;          //Message index at time of last activity check.         
    k64u messageIndex;              //Current message index. 
    kBool inMessage;                //Transmission state.
    k64u bytesWritten;              //Number of bytes written. 
    k64u lastBytesWritten;          //Number of bytes written at time of last stats check. 
    k64u lastDropCount;             //Number of messages dropped at time of last health update. 
    kLock statsLock;                //Channel stats lock. 

} kSvDataOutNetClass; 

kDeclareClassEx(kFs, kSvDataOutNet, kSvDataOutChannel)
        
kFsFx(kStatus) kSvDataOutNet_Init(kSvDataOutNet channel, kType type, kSvDataOut service, kTcpClient client, kSize maxQueueSize, kSize maxQueueCount, 
                                  kThreadPriorityClass priorityClass, k32s priorityOffset, kBitArray affinity, kAlloc alloc); 
kFsFx(kStatus) kSvDataOutNet_VRelease(kSvDataOutNet channel);

kFsFx(kStatus) kSvDataOutNet_ThreadEntry(kSvDataOutNet channel); 

kFsFx(kStatus) kSvDataOutNet_ReceiveConfiguration(kSvDataOutNet channel); 

kFsFx(kStatus) kSvDataOutNet_VSetMaxQueueSize(kSvDataOutNet channel, kSize size);
kFsFx(kStatus) kSvDataOutNet_VSetMaxQueueCount(kSvDataOutNet channel, kSize count);
kFsFx(kStatus) kSvDataOutNet_VSend(kSvDataOutNet channel, kMsgInfo message);
kFsFx(kStatus) kSvDataOutNet_VEndSession(kSvDataOutNet channel);
kFsFx(kStatus) kSvDataOutNet_VCheckActivity(kSvDataOutNet channel);
kFsFx(kBool) kSvDataOutNet_VIsActive(kSvDataOutNet channel);
kFsFx(kStatus) kSvDataOutNet_VSetThreadPriority(kSvDataOutNet channel, kThreadPriorityClass priorityClass, k32s priorityOffset);
kFsFx(kStatus) kSvDataOutNet_VSetThreadAffinity(kSvDataOutNet channel, kBitArray affinity);

kFsFx(kStatus) kSvDataOutNet_BeginMessage(kSvDataOutNet channel); 
kFsFx(kStatus) kSvDataOutNet_EndMessage(kSvDataOutNet channel); 

kFsFx(kStatus) kSvDataOutNet_OnHealthUpdate(kSvDataOutNet channel, kObject sender, kPointer unused);

#endif
