/** 
 * @file    kSvDiscovery.h
 * @brief   Declares the kSvDiscovery class and related types. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_DISCOVERY_H
#define K_FIRESYC_SERVER_DISCOVERY_H

#include <kFireSync/Server/kSvDef.h>
#include <kApi/Io/kNetwork.h>

/** Defines the signature for a discovery update-provider handler. */
typedef kStatus (kCall* kSvDiscoveryUpdateProviderFx)(kPointer receiver, kSize interfaceIndex, kDiscoveryInfo* info); 

/**
 * @internal
 * @class   kSvDiscovery
 * @extends kObject
 * @ingroup kFireSync-Server-Network
 * @brief   Broadcasts FDP-6 discovery update messages for this node.
 */
//typedef kObject kSvDiscovery;      --forward-declared in kFsDef.x.h
 
/** 
 * Constructs a kSvDiscovery object.
 *
 * @public              @memberof kSvDiscovery
 * @param   discovery   Destination for the constructed object handle. 
 * @param   node        Parent/owner.  
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) kSvDiscovery_Construct(kSvDiscovery* discovery, kSvNode node, kAlloc allocator);

kFsFx(kStatus) kSvDiscovery_SetRemotePort(kSvDiscovery discovery, k32u port);

kFsFx(kStatus) kSvDiscovery_SetUpdateProvider(kSvDiscovery discovery, kSvDiscoveryUpdateProviderFx function, kPointer receiver);

//thread-safe
kFsFx(kStatus) kSvDiscovery_StartBroadcasts(kSvDiscovery discovery); 

//thread-safe
kFsFx(kStatus) kSvDiscovery_StopBroadcasts(kSvDiscovery discovery); 

#include <kFireSync/Server/Network/kSvDiscovery.x.h>

#endif
