/** 
 * @file    kSvDiscoveryProvider.h
 * @brief   Declares the kSvDiscoveryProvider class. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_DISCOVERY_PROVIDER_H
#define K_FIRESYC_SERVER_DISCOVERY_PROVIDER_H

#include <kFireSync/Server/kSvDef.h>

/**
 * @internal
 * @class       kSvDiscoveryProvider
 * @extends     kObject
 * @implements  kDiscoveryProvider
 * @ingroup     kFireSync-Server-Network
 * @brief       Provides an implementation of the kDiscoveryProvider interface that supports kSvNode.
 */
//typedef kObject kSvDiscoveryProvider;            --forward-declared in kFsDef.x.h
 
/** 
 * Constructs a kSvDiscoveryProvider object.
 *
 * @public              @memberof kSvDiscoveryProvider
 * @return              Operation status. 
 */
kFsFx(kStatus) kSvDiscoveryProvider_Construct(kSvDiscoveryProvider* provider, kSystem system, kAlloc allocator); 

//called by kSystem to manage creation/destruction of server nodes
kFsFx(kStatus) kSvDiscoveryProvider_ConstructServerNode(kSvDiscoveryProvider provider, kHxNode hardwareNode, kSvNode* node);
kFsFx(kStatus) kSvDiscoveryProvider_DestroyServerNode(kSvDiscoveryProvider provider, k32u nodeId);
kFsFx(kStatus) kSvDiscoveryProvider_DestroyAllServerNodes(kSvDiscoveryProvider provider);

#include <kFireSync/Server/Network/kSvDiscoveryProvider.x.h>

#endif
