/** 
 * @file    kSvHealthOutChannel.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_HEALTH_OUT_CHANNEL_X_H
#define K_FIRESYC_SERVER_HEALTH_OUT_CHANNEL_X_H

typedef struct kSvHealthOutChannelClass
{
    kObjectClass base; 
    kSvHealthOut service;             //Parent. 

} kSvHealthOutChannelClass; 

typedef struct kSvHealthOutChannelVTable
{
    kObjectVTable base; 
        
    kStatus (kCall* VSend)(kSvHealthOutChannel channel, kObject info); 
    kBool (kCall* VIsActive)(kSvHealthOutChannel channel); 

} kSvHealthOutChannelVTable; 

kDeclareVirtualClassEx(kFs, kSvHealthOutChannel, kObject)
        
kFsFx(kStatus) kSvHealthOutChannel_Init(kSvHealthOutChannel channel, kType type, kSvHealthOut service, kAlloc alloc);
kFsFx(kStatus) kSvHealthOutChannel_VRelease(kSvHealthOutChannel channel);

kFsFx(kStatus) kSvHealthOutChannel_VSend(kSvHealthOutChannel channel, kObject info);
kFsFx(kBool) kSvHealthOutChannel_VIsActive(kSvHealthOutChannel channel);

#endif
