/** 
 * @file    kSvWeb.h
 * @brief   Declares the kSvWeb class and related types. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_WEB_H
#define K_FIRESYC_SERVER_WEB_H

#include <kFireSync/Server/kSvDef.h>
#include <kApi/Io/kNetwork.h>
#include <kApi/Io/kHttpServer.h>

/**
 * @internal
 * @class   kSvWeb
 * @extends kObject
 * @ingroup kFireSync-Server-Network
 * @brief   Manages a kHttpServer instance and implements default behaviour. 
 */
//typedef kObject kSvWeb;      --forward-declared in kFsDef.x.h
 
/** 
 * Constructs a kSvWeb object.
 *
 * @public              @memberof kSvWeb
 * @param   web         Destination for the constructed object handle. 
 * @param   node        Parent/owner.  
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) kSvWeb_Construct(kSvWeb* web, kSvNode node, kAlloc allocator);

kFsFx(kStatus) kSvWeb_SetHandler(kSvWeb web, kCallbackFx function, kPointer receiver); 

kFsFx(kStatus) kSvWeb_SetLocalEndPoint(kSvWeb web, kIpAddress address, k32u port);
kFsFx(kIpEndPoint) kSvWeb_LocalEndPoint(kSvWeb web);

kFsFx(kStatus) kSvWeb_StartService(kSvWeb web);
kFsFx(kStatus) kSvWeb_StopService(kSvWeb web);

#include <kFireSync/Server/Network/kSvWeb.x.h>

#endif
