/** 
 * @file    kSvDef.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_DEF_X_H
#define K_FIRESYC_SERVER_DEF_X_H

#define kSvNodeProcedureName    kText64         ///< Defines acceptable size of remote procedure name. 

/**
 * @internal
 * @struct  kSvNodeProcedureArgs
 * @extends kValue
 * @ingroup kFireSync-Server
 * @brief   Argument passed to a kSvNodeProcedureFx callback.
 * @see     kSvNodeProcedureFx, kSvNode_AddProcedure
*/
typedef struct kSvNodeProcedureArgs
{
    kObject input;          ///< Procedure argument. 
    kObject output;         ///< Procedure response. 
    kAlloc alloc;           ///< Allocator for response. 
} kSvNodeProcedureArgs;

/**
 * @internal
 * Callback signature for a kSvNode remote procedure.
 *
 * The final argument to this callback is a pointer to a kSvNodeProcedureArgs structure.
 * The input field of this structure represents an object received from the remote caller. This
 * object will exist only for the duration of the callback; to retain a copy, the object can
 * be shared or cloned.  The input field can be null if the remote caller does not supply
 * an argument.
 *
 * The output field of the kSvNodeProcedureArgs structure can be used to pass a reply back to
 * the remote caller. This field will be initialized to null by the kSvNodeProcedureFx caller
 * and can optionally be set during the callback. If this field is non-null upon return of the
 * callback, the object will be serialized as part of the remote invocation response, and then
 * disposed by the kSvNodeProcedureFx caller.
 *
 * @param   receiver   Receiver context pointer.
 * @param   node       Server node object (kSvNode)
 * @param   args       Pointer to callback argument.
 * @return             Operation status.
 * @see                kSvNode_AddProcedure, kSvNodeProcedureArgs
 */
typedef kStatus(kCall* kSvNodeProcedureFx)(kPointer receiver, kObject serverNode, kSvNodeProcedureArgs* args);

#endif
