/** 
 * @file    kUpgCompat5.h
 * @brief   Declares the kUpgCompat5 class. 
 *
 * @internal
 * Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef kFS_UPG_COMPAT5_H
#define kFS_UPG_COMPAT5_H

#include <kFireSync/kFsDef.h>

typedef k32s kHardwareType;                             ///< Identifies hardware type.

#define kFS_HARDWARE_M50                    (0)         ///< M50 based hardware
#define kFS_HARDWARE_M2                     (1)         ///< M2 based hardware
#define kFS_HARDWARE_LEGACY                 (2)         ///< All other hardware

typedef k32s kModuleType;                               ///< Identifies module type.

#define kFS_MODULE_TYPE_SENSOR              (0)
#define kFS_MODULE_TYPE_LEGACY              (2)

typedef k32s kSensorFirmware;

#define kFS_SENSOR_FIRMWARE_DSP             (0)
#define kFS_SENSOR_FIRMWARE_FPGA            (1)
#define kFS_SENSOR_FIRMWARE_BACKUP_DSP      (2)
#define kFS_SENSOR_FIRMWARE_BOOT_CONFIG     (3)
#define kFS_SENSOR_FIRMWARE_EXT_FPGA        (4)
#define kFS_SENSOR_FIRMWARE_BOOTLOADER      (5)

/**
 * @class       kUpgCompat5
 * @extends     kPointer
 * @ingroup     kFireSync-Utils
 * @brief       Represents a device upgrade package.
 */
typedef kObject kUpgCompat5;
kDeclareClassEx(kFs, kUpgCompat5, kObject)

typedef kObject kUpgCompat5Target;
kDeclareClassEx(kFs, kUpgCompat5Target, kObject)

typedef kObject kUpgCompat5Model;
kDeclareClassEx(kFs, kUpgCompat5Model, kObject)

typedef kObject kUpgCompat5Firmware;
kDeclareClassEx(kFs, kUpgCompat5Firmware, kObject)

typedef kObject kUpgCompat5StorageFile;
kDeclareClassEx(kFs, kUpgCompat5StorageFile, kObject)

/** 
 * Loads an upgrade package object from file.
 *
 * @public              @memberof kUpgCompat5
 * @param   package     Receives constructed upgrade package object.   
 * @param   fileName    File name of the upgrade package.
 * @param   alloc       Memory allocator (or kNULL for default).
 * @return              Operation status. 
 */
 kFsFx(kStatus) kUpgCompat5_Load(kUpgCompat5* package, const kChar* fileName, kAlloc alloc);

#include <kFireSync/Upgrade/kUpgCompat5.x.h>

#endif 
