/** 
 * @file    kUpgCompat5.x.h
 *
 * @internal
 * Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef kFS_UPG_COMPAT5_X_H
#define kFS_UPG_COMPAT5_X_H

#include <kApi/Data/kXml.h>
#include <kFireSync/Data/kArchive.h>

typedef struct kUpgCompat5NamePair 
{
    k32s value;
    const kChar* name;
} kUpgCompat5NamePair;

typedef k32s kUpgCompat5StorageOption;                  // Upgrade storage options.

#define kFS_UPG_COMPAT5_STORAGE_DEFAULT    (0)          // Default.
#define kFS_UPG_COMPAT5_STORAGE_OVERWRITE  (1)          // Overwrite.
#define kFS_UPG_COMPAT5_STORAGE_CREATE     (2)          // Creates.
#define kFS_UPG_COMPAT5_STORAGE_DELETE     (3)          // Delete

#define kFS_UPG_COMPAT5_PACKAGE_RESCUE_MODEL            "[SysReservedModel_Rescue]"
#define kFS_UPG_COMPAT5_PACKAGE_UPDATER_FILE            "[SysReservedFile_Updater]"
#define kFS_UPG_COMPAT5_PACKAGE_UPDATER_EXECUTABLE      "kUpdate.exe"

kFsFx(kStatus) kUpgCompat5_Construct(kUpgCompat5 *package, kAlloc alloc);

kFsFx(kStatus) kUpgCompat5_Attach(kUpgCompat5 package, const void* data, k32u size);
kFsFx(kStatus) kUpgCompat5_AttachArchive(kUpgCompat5 package, kArchive archive);

kFsFx(kStatus) kUpgCompat5_Open(kUpgCompat5 package, const kChar *fileName);

kFsFx(kStatus) kUpgCompat5_Clear(kUpgCompat5 package);

kFsFx(kStatus) kUpgCompat5_FileSize(kUpgCompat5 package, const kChar *fileName, k64u *size);
kFsFx(kStatus) kUpgCompat5_FileData(kUpgCompat5 package, const kChar *fileName, const void **data);

kFsFx(kStatus) kUpgCompat5_AddUpdater(kUpgCompat5 package, const kChar* updaterDir);

kFsFx(kStatus) kUpgCompat5_SetExtendedInfo(kUpgCompat5 package, kXml xml);
kFsFx(kStatus) kUpgCompat5_ExtendedInfo(kUpgCompat5 package, kXml* xml); // do not free

kFsFx(kSize) kUpgCompat5_ModelCount(kUpgCompat5 package);
kFsFx(kUpgCompat5Model) kUpgCompat5_ModelAt(kUpgCompat5 package, kSize index);
kFsFx(kSize) kUpgCompat5_TargetCount(kUpgCompat5 package);
kFsFx(kUpgCompat5Target) kUpgCompat5_TargetAt(kUpgCompat5 package, kSize index);

kFsFx(kStatus) kUpgCompat5Model_Construct( kUpgCompat5* model, const kChar* name, kVersion version, kAlloc alloc );
kFsFx(kStatus) kUpgCompat5Model_Init( kUpgCompat5Model model, kType type, const kChar* name, kVersion version, kAlloc alloc );
kFsFx(kStatus) kUpgCompat5Model_VRelease( kUpgCompat5Model model);
kFsFx(kStatus) kUpgCompat5Model_Name(kUpgCompat5Model model, kChar *buffer, k32u bufferSize);
kFsFx(kStatus) kUpgCompat5Model_Version(kUpgCompat5Model model, kVersion *version);
kFsFx(kSize) kUpgCompat5Model_StorageFileCount(kUpgCompat5Model model);
kFsFx(kStatus) kUpgCompat5Model_AddStorageFile( kUpgCompat5Model model, kUpgCompat5StorageFile file);
kFsFx(kUpgCompat5StorageFile) kUpgCompat5Model_StorageFileAt(kUpgCompat5Model model, kSize index);

kFsFx(kStatus) kUpgCompat5Target_Construct(kUpgCompat5Target* target, 
                                           kUpgCompat5Model model, 
                                           kModuleType nodeType, 
                                           kHardwareType archType, 
                                           kAlloc alloc);
kFsFx(kStatus) kUpgCompat5Target_Init( kUpgCompat5Target target, 
                                      kType type, 
                                      kUpgCompat5Model model, 
                                      kModuleType nodeType, 
                                      kHardwareType archType, 
                                      kAlloc alloc );
kFsFx(kStatus) kUpgCompat5Target_VRelease(kUpgCompat5Target target);
kFsFx(kStatus) kUpgCompat5Target_Model(kUpgCompat5Target target, kUpgCompat5Model *model);
kFsFx(kStatus) kUpgCompat5Target_NodeType(kUpgCompat5Target target, kModuleType *type);
kFsFx(kStatus) kUpgCompat5Target_HardwareType(kUpgCompat5Target target, kHardwareType *type);
kFsFx(kSize) kUpgCompat5Target_FirmwareCount(kUpgCompat5Target target);
kFsFx(kUpgCompat5Firmware) kUpgCompat5Target_FirmwareAt(kUpgCompat5Target target, kSize index);
kFsFx(kStatus) kUpgCompat5Target_AddFirmware(kUpgCompat5Target target,
                                             k32s componentType, 
                                             const kChar *sourceFile);

kFsFx(kStatus) kUpgCompat5StorageFile_Construct( kUpgCompat5StorageFile* file, 
                                                kUpgCompat5StorageOption options,
                                                const kChar* sourceFile,
                                                const kChar* destination, 
                                                kAlloc alloc );

kFsFx(kStatus) kUpgCompat5StorageFile_Init( kUpgCompat5StorageFile file, 
                                           kType type,
                                           kUpgCompat5StorageOption options,
                                           const kChar* sourceFile,
                                           const kChar* destination, 
                                           kAlloc alloc);

kFsFx(kStatus) kUpgCompat5StorageFile_VRelease(kUpgCompat5StorageFile file);
kFsFx(kStatus) kUpgCompat5StorageFile_Source(kUpgCompat5StorageFile file, kChar *buffer, k32u bufferSize);
kFsFx(kStatus) kUpgCompat5StorageFile_Destination(kUpgCompat5StorageFile file, kChar *buffer, k32u bufferSize);
kFsFx(kStatus) kUpgCompat5StorageFile_Options(kUpgCompat5StorageFile file, kUpgCompat5StorageOption *option);

kFsFx(kStatus) kUpgCompat5Firmware_Construct( kUpgCompat5Firmware* firmware, 
                                             kSensorFirmware componentType, 
                                             const kChar* sourceFile, 
                                             kAlloc alloc );
kFsFx(kStatus) kUpgCompat5Firmware_Init( kUpgCompat5 package, 
                                        kType type, 
                                        kSensorFirmware componentType, 
                                        const kChar* sourceFile, 
                                        kAlloc alloc );

kFsFx(kStatus) kUpgCompat5Firmware_VRelease(kUpgCompat5Firmware firmware);
kFsFx(kStatus) kUpgCompat5Firmware_SourceFile(kUpgCompat5Firmware file, kChar *buffer, k32u bufferSize);
kFsFx(kStatus) kUpgCompat5Firmware_Type(kUpgCompat5Firmware file, kSensorFirmware* type);

#include <kFireSync/Upgrade/kUpgCompat5.z.h>

#endif
