/** 
 * @file    kUpgScript.h
 * @brief   Declares the kUpgScript class. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef kFS_UPG_SCRIPT_H
#define kFS_UPG_SCRIPT_H

#include <kFireSync/kFsDef.h>
#include <kFireSync/Upgrade/kUpgAction.h>

/**
 * Represents an upgrade script.
 *
 * @class       kUpgScript
 * @extends     kObject
 * @ingroup     kFireSync-Upgrade
 */
typedef kObject kUpgScript;

/** @cond */
kDeclareClassEx(kFs, kUpgScript, kObject)
/** @endcond */

kFsFx(kStatus) kUpgScript_Construct(kUpgScript* action, kAlloc alloc);

kFsFx(kStatus) kUpgScript_Read(kUpgScript action, kXml xml, kXmlItem item);
kFsFx(kStatus) kUpgScript_Write(kUpgScript action, kXml xml, kXmlItem item);

kFsFx(kSize) kUpgScript_ActionCount(kUpgScript script);
kFsFx(kUpgAction) kUpgScript_ActionAt(kUpgScript script, kSize index);

#endif
