/** 
 * @file    kUpgTask.h
 * @brief   Declares the kUpgTask class. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef kFS_UPG_TASK_H
#define kFS_UPG_TASK_H

#include <kFireSync/kFsDef.h>
#include <kApi/Utils/kEvent.h>
#include <kFireSync/Client/kSystem.h>
#include <kFireSync/Client/kNode.h>
#include <kFireSync/Data/kArchive.h>

/**
 * Represents an asynchronous task.
 *
 * @class       kUpgTask
 * @extends     kObject
 * @ingroup     kFireSync-Upgrade
 */
typedef kObject kUpgTask;

/** @cond */
kDeclareClassEx(kFs, kUpgTask, kObject)
kDeclareValueEx(kFs, kUpgTaskDirectory, kValue)
kDeclareValueEx(kFs, kUpgTaskDirectoryDelete, kValue)
kDeclareValueEx(kFs, kUpgTaskFile, kValue)
kDeclareValueEx(kFs, kUpgTaskFirmware, kValue)
kDeclareValueEx(kFs, kUpgTaskFileDelete, kValue)
kDeclareValueEx(kFs, kUpgTaskVersion, kValue)
kDeclareValueEx(kFs, kUpgTaskRescueWaitSet, kValue)
kDeclareValueEx(kFs, kUpgTaskReset, kValue)
/** @endcond */

kFsFx(kStatus) kUpgTask_ConstructFirmware(kUpgTask *task, kNode node, kNodeFirmwareType type, kArchive package, const kChar* source, kAlloc alloc);
kFsFx(kStatus) kUpgTask_ConstructDirectory(kUpgTask *task, kNode node, const kChar* name, kArchive package, const kChar* source, kAlloc alloc);
kFsFx(kStatus) kUpgTask_ConstructDirectoryDelete(kUpgTask *task, kNode node,  const kChar* name, kAlloc alloc);
kFsFx(kStatus) kUpgTask_ConstructFile(kUpgTask *task, kNode node, const kChar* name, kArchive package, const kChar* source, kBool overwrite, kAlloc alloc);
kFsFx(kStatus) kUpgTask_ConstructFileDelete(kUpgTask *task, kNode node, const kChar* name, kAlloc alloc);
kFsFx(kStatus) kUpgTask_ConstructVersion(kUpgTask *task, kNode node, kVersion version, kAlloc alloc);
kFsFx(kStatus) kUpgTask_ConstructRescueWaitSet(kUpgTask *task, kNode node, kBool enable, kAlloc alloc);
kFsFx(kStatus) kUpgTask_ConstructReset(kUpgTask *task, kNode node, kAlloc alloc);

kFsFx(kEvent) kUpgTask_ProgressEvent(kUpgTask task);
kFsFx(kStatus) kUpgTask_SetLogEvent(kUpgTask task, kEvent event);

kFsFx(kStatus) kUpgTask_Begin(kUpgTask task);
kFsFx(kStatus) kUpgTask_End(kUpgTask task, kBool* done, kStatus* status);
kFsFx(k64u) kUpgTask_Weight(kUpgTask task);
kFsFx(k32u) kUpgTask_Progress(kUpgTask task);
kFsFx(kStatus) kUpgTask_SetProgress(kUpgTask task, k32u progress);

#endif
