/** 
 * @file    kUpgValidator.h
 * @brief   Declares the kUpgValidator class. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef kFS_UPG_VALIDATOR_H
#define kFS_UPG_VALIDATOR_H

#include <kFireSync/kFsDef.h>
#include <kFireSync/Data/kPropertyList.h>
#include <kFireSync/Upgrade/kUpgRuleSet.h>

/**
 * Performs package validation using a provided ruleset.
 *
 * @class       kUpgValidator
 * @extends     kObject
 * @ingroup     kFireSync-Upgrade
 */
typedef kObject kUpgValidator;

/** @cond */
kDeclareClassEx(kFs, kUpgValidator, kObject)
/** @endcond */

kFsFx(kStatus) kUpgValidator_Construct(kUpgValidator* validator, kAlloc alloc);

kFsFx(kStatus) kUpgValidator_Validate(kUpgValidator validator, kPropertyList id, kUpgRuleSet rules);
kFsFx(kBool) kUpgValidator_Result(kUpgValidator validator);
kFsFx(kSize) kUpgValidator_ErrorCount(kUpgValidator validator);
kFsFx(const kChar*) kUpgValidator_ErrorAt(kUpgValidator validator, kSize index);

#endif
