/** 
 * @file    kFtpUtils.h
 * @brief   FTP utility functions.
 *
 * @internal
 * Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_BOOT2_FTP_UTILS_H
#define K_BOOT2_FTP_UTILS_H

#include <kFireSync/kFsDef.h>
#include <kApi/Io/kNetwork.h>
#include <kApi/Io/kTcpClient.h>

/* 
 * References:
 * https://www.ietf.org/rfc/rfc959.txt
 */

typedef kStatus (kCall* kFtpUtilsGetStreamFx)(kPointer receiver, kStream data); 

kFsFx(kStatus) kFtpUtils_GetStream(kIpAddress serverAddress, k32u serverPort, k64u connectTimeout, const kChar* user, const kChar* password, const kChar* path, kFtpUtilsGetStreamFx handler, kPointer receiver); 

kFsFx(kStatus) kFtpUtils_GetFile(kIpAddress serverAddress, k32u serverPort, k64u connectTimeout, const kChar* user, const kChar* password, const kChar* path, kStream dest); 

#endif
