#ifndef K_LD_CAL_X_H
#define K_LD_CAL_X_H

#include <kApi/kApi.h>
#include <kFireSync/Data/kDataTree.h>

typedef struct kLdCalClass
{
    kObjectClass base;

    kSize sensorId;
    kString timestamp;
    kString stationId;

    kSize driverIndex;
    kSize driverId;
    kString driverIdLabel;
    kLightModel driverModel;
    kLightDiodeModel diodeModel;

    kVersion driverVersion;
    k64f driverTemperature;

    kSize powerInputBegin;
    kSize powerInputStep;
    kSize powerInputDefault;
    kSize powerInputDevice;

    kSize limitInputBegin;
    kSize limitInputStep;
    kSize limitInputDefault;
    kSize limitInputDevice;

    kArray1 powerCal;
    kArray1 limitCal;

} kLdCalClass;

kDeclareClassEx(kFs, kLdCal, kObject)

kFsFx(kStatus) kLdCal_Init(kLdCal cal, kAlloc alloc);

kFsFx(kStatus) kLdCal_Write(kLdCal cal, kDataTree tree);
kFsFx(kStatus) kLdCal_VRelease(kLdCal cal);
kFsFx(kStatus) kLdCal_Read(kLdCal cal, kDataTree tree);

/**
* Formats the light model property into an internal id (string), to facilitate future changes to enumerated values
*
* @public               @memberof kLdCal
* @param   model        Model enumerator
* @return               String matching the model enumerator or kNULL if the enumerator is not recognized
*/
kFsFx(const kChar*) kLdCal_FormatLightModel(kLightModel model);

/**
* Parses the light model string. If the string does not match any of the supported drivers, returns kLIGHT_MODEL_NULL
*
* @public               @memberof kLdCal
* @return               Light model type corresponding to the parsed string or kLIGHT_MODEL_NULL if match cannot be found
*/
kFsFx(kLightModel) kLdCal_ParseLightModel(const kChar* modelName);

#endif
