/** 
 * @file    kStorageStream.x.h
 *
 * @internal
 * Copyright (C) 2012-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_STORAGE_STREAM_X_H
#define K_FIRESYNC_STORAGE_STREAM_X_H

#include <kFireSync/Client/kStorage.h>

typedef struct kStorageStreamClass
{   
    kStreamClass base; 
    kMemory innerStream;            //used to implement stream interface
    kStorage storage;               //link to sensor storage
    kChar fileName[kPATH_MAX];      //file name in storage
    kBool isOpen;                   //was the stream successfully opened
    kBool isModified;               //has the stream been modified since the last write
} kStorageStreamClass;

kDeclareClassEx(kFs, kStorageStream, kStream)

kFsFx(kStatus) kStorageStream_Init(kStorageStream stream, kType type, kStorage storage, const kChar* fileName, kBool read, kAlloc alloc); 
kFsFx(kStatus) kStorageStream_VRelease(kStorageStream stream);

kFsFx(kStatus) kStorageStream_ResolveModule(kObject module, k32u deviceId, kStorage* storage); 

kFsFx(kStatus) kStorageStream_VReadImpl(kStorageStream stream, void* buffer, kSize size);
kFsFx(kStatus) kStorageStream_VWriteImpl(kStorageStream stream, const void* buffer, kSize size);
kFsFx(kStatus) kStorageStream_VSeek(kStorageStream stream, k64s offset, kSeekOrigin origin);
kFsFx(kStatus) kStorageStream_VFlush(kStorageStream stream);

#endif
