/** 
 * @file    kTarUtils.x.h
 * @brief   TAR utility functions.
 *
 * @internal
 * Copyright (C) 2016-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_TAR_UTILS_X_H
#define K_FIRESYNC_TAR_UTILS_X_H

#include <kFireSync/kFsDef.h>

#define kTAR_UTILS_REGTYPE                      '0'            /* regular file */
#define kTAR_UTILS_DIRTYPE                      '5'            /* directory */

typedef struct kTarItem
{
    kText128 name;
    k64u start;
    k64u length;
    k8u type;
} kTarItem;

kFsFx(kStatus) kTarUtils_OpenFile(kFile* file, const kChar* fileName, kTarItem* firstItem, kAlloc alloc);
kFsFx(kStatus) kTarUtils_OpenStream(kStream stream, kTarItem* firstItem);

kFsFx(kStatus) kTarUtils_SeekNext(kStream stream, const kTarItem* item, kTarItem* nextItem);

kFsFx(kStatus) kTarUtils_ExtractFile(const kChar* tarFile, const kChar* outputPath, kAlloc alloc);
kFsFx(kStatus) kTarUtils_ExtractStream(kStream stream, const kChar* outputPath, kAlloc alloc);

#endif
