#ifndef LMITECH_KBLOB_H_INCLUDED
#define LMITECH_KBLOB_H_INCLUDED

#include <kVision/Common/kVision.h>
#include <kApi/kType.h>
#include <kApi/kAlloc.x.h>
#include <kApi/Data/kImage.h>

typedef struct kBlobItem  
{
    k32u perimx;                // X coordinate of first pixel detected in blob.
    k32u perimy;                // Y coordinate of fist pixel detected in blob.
    k32u xmin;                  // Left x-coordinate of blob bounding box.
    k32u ymin;                  // Top y-coordinate of blob bounding box.
    k32u xmax;                  // Right x-coordinate of blob bounding box.
    k32u ymax;                  // Bottom y-coordinate of blob bounding box.
    k32u area;                  // Area of blob.
    k32u boxarea;               // Area of blob bounding box.
    k32u xdiff;                 // Width of blob bounding box.
    k32u ydiff;                 // Height of blob bounding box.
    k64f sumX;
    k64f sumXX;
    k64f sumY;
    k64f sumYY;
    k64f sumXY;
    k64f sumXXX;
    k64f sumYYY;
    k64f sumXXY;
    k64f sumXYY;
    k64f angle;                 // Angle of major axis of best-fit ellipse (degrees).
    k64f xc;                    // X-coordinate of blob center of mass.
    k64f yc;                    // Y-coordinate of blob center of mass.
    k64f major;                 // Length of major axis of best-fit ellipse.
    k64f minor;                 // Length of minor axis of best-fit ellipse.
    k64f axratio;               // Ratio of minor axis to major axis.
    k64f fillratio;             // Ratio of blob area to product of major and minor axes.
    k64f skew;                  // Measure of symmetry about major axis (3rd-order moment about the mean). 
} kBlobItem;

kDeclareValueEx(kVs, kBlobItem, kValue)

typedef kObject kBlob;

kVsFx(kStatus) kBlob_Construct(kBlob* blob, k32u nMaxRL, k32u nMaxBlobs, kObject allocator);
kVsFx(kStatus) kBlob_Execute(kBlob blob, kImage image, kBool bAdvanced, k32u nBorder);

kVsFx(const kBlobItem*) kBlob_Data(kBlob blob); 
kVsFx(k32u) kBlob_Count(kBlob blob);

#define kBLOB_DATA(BLOB)    kxBLOB_DATA(BLOB)
#define kBLOB_COUNT(BLOB)   kxBLOB_COUNT(BLOB)

#include <kVision/Common/kBlob.x.h>

#endif      /* #ifndef LMITECH_KBLOB_H_INCLUDED */
