#ifndef LMITECH_kXBOOTSTRAPFIT_H_INCLUDED
#define LMITECH_kXBOOTSTRAPFIT_H_INCLUDED

#include <kVision/Common/kPolynomialFit.h>
#include <kApi/Data/kArrayList.h>

typedef struct kBootstrapFitClass 
{
    kObjectClass base;
    kPolynomialFit polynomialFit;
    kArrayList polynomials;
    kSize resampleCount;
    kBool correlatedMode;
    kAlloc alloc;

} kBootstrapFitClass;

kDeclareClassEx(kVs, kBootstrapFit, kObject)

kVsFx(kStatus) kBootstrapFit_Init(kBootstrapFit fit, kType classType, k32s polyOrder, kSize resampleCount, kBool correlatedMode, kAlloc allocator);
kVsFx(kStatus) kBootstrapFit_VRelease(kBootstrapFit fit);
kStatus  kBootstrapFit_SynthesiseDataset(kBootstrapFit fit, kArrayList x, kArrayList y, kArrayList* synthesisedX, kArrayList* synthesisedY);
kStatus kBootstrapFit_ConstructRandomSubset(kBootstrapFit fit, kArrayList inputSet, kSize n, kArrayList* selectedSet, kArrayList* unselectedSet);
kStatus kBootstrapFit_ConstructRandomBlock(kBootstrapFit fit, kArrayList inputSet, kSize blockCount, kArrayList* selectedBlock, kArrayList* unselectedSubset);


#define kBOOTSTRAP_FIT(FIT)                     ((kBootstrapFitClass*)(FIT))
#define kBOOTSTRAP_FIT_VTABLE(FIT)              ((kBootstrapFitVtable*)kOBJECT_INFO(FIT)->vtable)

#endif
