/** 
 * @file    kEthernetTest.x.h
 * 
 * @internal
 * Copyright (C) 2015-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef LMITECH_KVISION_KETHERNET_TEST_X_H
#define LMITECH_KVISION_KETHERNET_TEST_X_H

#include <kFireSync/Action/kAxAction.h>
#include <kVision/Common/kEthernetTestInfo.h>

#define kETHERNET_TEST_THREAD_PRIORITY          (-1)
#define kETHERNET_TEST_QUIT_QUERY_PERIOD        (100000)

/* 
 * kEthernetTestStartAction
 */

typedef struct kEthernetTestStartActionClass
{
    kAxActionClass base; 
} kEthernetTestStartActionClass; 

kDeclareClassEx(kVs, kEthernetTestStartAction, kAxAction)

kVsFx(const kChar*) kEthernetTestStartAction_VDescription();
kVsFx(kStatus) kEthernetTestStartAction_VInvoke(kEthernetTestStartAction action, kObject input, kObject* output, kAlloc alloc);

/* 
 * kEthernetTestStopAction
 */

typedef struct kEthernetTestStopActionClass
{
    kAxActionClass base; 
} kEthernetTestStopActionClass; 

kDeclareClassEx(kVs, kEthernetTestStopAction, kAxAction)

kVsFx(const kChar*) kEthernetTestStopAction_VDescription();
kVsFx(kStatus) kEthernetTestStopAction_VInvoke(kEthernetTestStopAction action, kObject input, kObject* output, kAlloc alloc);

/* 
 * kEthernetTest
 */

typedef struct kEthernetTestStatic
{
    kTcpServer server;
    kTcpClient connection;
    kThread serverThread;
    kThread clientThread;
    kAtomic32s shouldQuitServer;
    kAtomic32s shouldQuitClient;
    kByte* buffer;
    
    k32u port;
    k64u period;
    kSize dataSize;
    
} kEthernetTestStatic; 

kDeclareStaticClassEx(kVs, kEthernetTest)

kVsFx(kStatus) xkEthernetTest_InitStatic();
kVsFx(kStatus) xkEthernetTest_ReleaseStatic();

kVsFx(kStatus) kEthernetTest_ServerThreadEntry(kPointer context);
kVsFx(kStatus) kEthernetTest_ClientThreadEntry(kPointer context);

kVsFx(kStatus) kEthernetTest_Start(kXml xml);
kVsFx(kStatus) kEthernetTest_Stop(void);

#endif
