#ifndef LMITECH_KXPOLYNOMIAL_H_INCLUDED
#define LMITECH_KXPOLYNOMIAL_H_INCLUDED

#include <kApi/Data/kArray1.h>

typedef struct kPolynomialClass 
{
    kObjectClass base;
    k32u order;
    kObject coefficients;
} kPolynomialClass;

kDeclareClassEx(kVs, kPolynomial, kObject)

kVsFx(kStatus) kPolynomial_Init(kPolynomial function, kType classType, k32u order, kAlloc allocator);
kVsFx(kStatus) kPolynomial_Release(kPolynomial function);

kVsFx(kStatus) kPolynomial_VInitClone(kPolynomial function, kPolynomial source, kAlloc allocator);
kVsFx(kStatus) kPolynomial_VRelease(kPolynomial function);
kVsFx(kSize)   kPolynomial_VSize(kPolynomial function);
kVsFx(k64f)    kPolynomial_VApply(kPolynomial function, k64f x);
kVsFx(kStatus) kPolynomial_VApplyN(kPolynomial function, const k64f* x, k64f* f, k32u count);

//sealed optimization
#define kPolynomial_VApply                      kPolynomial_Apply
#define kPolynomial_VApplyN                     kPolynomial_ApplyN

#define kPOLYNOMIAL(HANDLE)                     ((kPolynomialClass*)(HANDLE))
#define kPOLYNOMIAL_VTABLE(HANDLE)              ((kPolynomialVtable*)kOBJECT_INFO(HANDLE)->vtable)
#define kxPOLYNOMIAL_COEFFICIENTS(HANDLE)       ((k64f*)(kPOLYNOMIAL(HANDLE)->coefficients))
#define kxPOLYNOMIAL_ORDER(HANDLE)              (kPOLYNOMIAL(HANDLE)->order)

#endif  /* #ifndef LMITECH_KXPOLYNOMIAL_H_INCLUDED */
