#ifndef LMITECH_KXVISION_H_INCLUDED
#define LMITECH_KXVISION_H_INCLUDED

#include <kApi/kApiDef.h>

#if defined (KVISION_EXPORTS)
#   define kVsFx(TYPE)    kExportFx(TYPE)
#   define kVsDx(TYPE)    kExportDx(TYPE)
#else
#   define kVsFx(TYPE)    kImportFx(TYPE)    
#   define kVsDx(TYPE)    kImportDx(TYPE)    
#endif

#define KVISION_EXPORT(TYPE) kVsFx(TYPE)

//////////////////////////////////////////////////////////////////////////
// CUDA 
//////////////////////////////////////////////////////////////////////////

#ifdef  __CUDA_ARCH__
#   define kCuda                __device__
#   define kCudaInline          __device__ __forceinline__
#   define kCudaInlineFx(TYPE)  __device__ __forceinline__ TYPE
#else
#   if _MSC_VER >= 1500
#       define kCuda
#       define kCudaInline          __forceinline
#       define kCudaInlineFx(TYPE)  __forceinline TYPE kCall
#   else
#       define kCuda
#       define kCudaInline          inline
#       define kCudaInlineFx(TYPE)  kCudaInline TYPE kCall
#   endif
#endif

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

#define cudaCheck(ans)\
{\
  if((ans) != cudaSuccess)\
  {\
    kLogf("GPUassert: %s [%s] [%d]\n", cudaGetErrorString(ans), __FILE__, __LINE__);\
    return kERROR;\
  }\
}

#define cudaTest(ans)\
{\
  if((ans) != cudaSuccess)\
  {\
    kLogf("GPUassert: %s [%s] [%d]\n", cudaGetErrorString(ans), __FILE__, __LINE__);\
    kThrow(kERROR);\
  }\
}

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

#endif      /* #ifndef LMITECH_KXVISION_H_INCLUDED */
