/**
* @file    kG3dContourClosedLine.x.h
* @brief   
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc. All rights reserved.
*/

#ifndef KVISION_kG3D_CONTOURCLOSEDLINE_X_H
#define KVISION_kG3D_CONTOURCLOSEDLINE_X_H


#define KVISION_kG3D_CONTOURCLOSEDLINE_MAX_WIDTH         15 
#define KVISION_kG3D_CONTOURCLOSEDLINE_MAX_WINDOW        31 
#define KVISION_kG3D_CONTOURCLOSEDLINE_GAPS_MAX          20 

typedef struct kG3dContourClosedLineStausType
{
    k32s zmax, zmin;
    k32s gapsAngleStart[KVISION_kG3D_CONTOURCLOSEDLINE_GAPS_MAX];
    k32s gapsAngleEnd[KVISION_kG3D_CONTOURCLOSEDLINE_GAPS_MAX];
    k32s gapsAngleStartZ[KVISION_kG3D_CONTOURCLOSEDLINE_GAPS_MAX];
    k32s gapsAngleEndZ[KVISION_kG3D_CONTOURCLOSEDLINE_GAPS_MAX];
    k32s gapsStartIndex[KVISION_kG3D_CONTOURCLOSEDLINE_GAPS_MAX];
    k32s gapsEndIndex[KVISION_kG3D_CONTOURCLOSEDLINE_GAPS_MAX];
    k32s gapsStartDist[KVISION_kG3D_CONTOURCLOSEDLINE_GAPS_MAX];
    k32s gapsEndDist[KVISION_kG3D_CONTOURCLOSEDLINE_GAPS_MAX];
    k32s gapsCount;
    kBool direction;
    k32s validCount;
    k32s success;
    k32s xm, ym;
}kG3dContourClosedLineStausType;

typedef struct kG3dContourClosedLineClass
{
    kObjectClass base;
    kArray1 contourPoints;
    kArrayList profiles;
    kArray1 histoSum;
    kArray1 status;
    kPoint3d64f scale;
    k32s lineCount;
    k32s inputLineCount;
    k32s imageSizeX;
    k32s imageSizeY;
    k32s outPointCount;
    k32s histogramSize;
    k32s filterWidth;
    k32s filterRepeat;
    k32s curveIndex;
    
    k32s maxGapsAngle;
    k64f dev;
    kBool success;
    k32s testMax;
    k32s pointCount;
    k32s repeat;
    kG3dClosedContourType currentLine;
    kBool isProfilesInit;
    k32s weight[KVISION_kG3D_CONTOURCLOSEDLINE_MAX_WINDOW];
    kBool borderExclude;
    k32s areaMinimum;

    k32s sampleIndex;
    k32s repeatIndex;

} kG3dContourClosedLineClass;

kDeclareClassEx(kVs, kG3dContourClosedLine, kObject)

kStatus kG3dContourClosedLine_Init(kG3dContourClosedLine closedLine, kType classType, kAlloc alloc);

kVsFx(kStatus) kG3dContourClosedLine_VInitClone(kG3dContourClosedLine closedLine, kG3dContourClosedLine source, kAlloc allocator);
kVsFx(kSize)   kG3dContourClosedLine_VSize(kG3dContourClosedLine closedLine);
kVsFx(kStatus) kG3dContourClosedLine_VRelease(kG3dContourClosedLine closedLine);

kStatus kG3dContourClosedLine_ReleaseProfile(kG3dContourClosedLine closedLine);
kStatus kG3dContourClosedLine_ReleaseBuffer(kG3dContourClosedLine closedLine);
kStatus kG3dContourClosedLine_Setup(kG3dContourClosedLine closedLine);

kStatus kG3dContourClosedLine_CalculateCurrentCurve(kG3dContourClosedLine closedLine, k32s lineIndex);

//kStatus kG3dContourClosedLine_Center(kG3dContourClosedLine closedLine);
kStatus kG3dContourClosedLine_FillHistogram(kG3dContourClosedLine closedLine);
kStatus kG3dContourClosedLine_UpdateHistogram(kG3dContourClosedLine closedLine);
kStatus kG3dContourClosedLine_HistogramDeviation(kG3dContourClosedLine closedLine);
kStatus kG3dContourClosedLine_HistogramOutlier(kG3dContourClosedLine closedLine);
kStatus kG3dContourClosedLine_FillGaps(kG3dContourClosedLine closedLine);
kStatus kG3dContourClosedLine_ResetPoints(kG3dContourClosedLine closedLine);
kStatus kG3dContourClosedLine_MergeCurrentCurve(kG3dContourClosedLine closedLine, k32s lineIndex);

#endif  /* KVISION_kG3D_CONTOURCLOSEDLINE_X_H */
