#ifndef KVISION_G3D_PALETTE_X_H
#define KVISION_G3D_PALETTE_X_H

typedef struct kG3dPaletteClass
{
    kObjectClass base;
    kG3dPaletteItem palItems[kG3dPaletteEnd];
    kArray1 palArrays[kG3dPaletteEnd];
}kG3dPaletteClass;

kDeclareClassEx(kVs, kG3dPalette, kObject)

kStatus kG3dPalette_Init(kG3dPalette palette, kType classType, kAlloc alloc);

kVsFx(kStatus) kG3dPalette_VRelease(kG3dPalette palette);
kVsFx(kStatus) kG3dPalette_VInitClone(kG3dPalette palette, kG3dPalette source, kAlloc allocator);
kVsFx(kSize)   kG3dPalette_VSize(kG3dPalette palette);

kVsFx(kStatus) kG3dPalette_setPal(kG3dPalette palette, kG3dPaletteItem palItem, kG3dPaletteType type);
kVsFx(kStatus) kG3dPalette_setPaletteSettings(kG3dPalette palette, kArray1 params);

kStatus kG3dPalette_read(kG3dPalette palette, kDataTree tree, kDataTreeItem item);
kStatus kG3dPalette_writeItem(kG3dPaletteItem palItem, kDataTree tree, kDataTreeItem item, const kChar* label);

kStatus kG3dPalette_setDefaultPaletteSettings(kG3dPalette palette);
kStatus kG3dPalette_updateAllPaletteArrays(kG3dPalette palette);
kStatus kG3dPalette_updatePaletteArrayItem(kG3dPalette palette, kG3dPaletteType type);
kStatus kG3dPalette_updatePaletteArrayItemHSV(kG3dPalette palette, kG3dPaletteType type);
kStatus kG3dPalette_rgbToHsv(kPoint3d32s* hsv, kPoint3d32s rgb);
kStatus kG3dPalette_hsvToRgb(kPoint3d32s* rgb, kPoint3d32s hsv);
kStatus kG3dPalette_setDefaultDepthImagePal(kG3dPalette palette);
kStatus kG3dPalette_setDefaultDifferenceImagePal(kG3dPalette palette);
kStatus kG3dPalette_setDefaultPhotoBackImagePal(kG3dPalette palette);
kStatus kG3dPalette_setDefaultPhotoFrontImagePal(kG3dPalette palette);

#endif
