/**
* @file    kG3dPolygonMask.h
* @brief   Declares the kG3dPolygonMask class. 
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc. All rights reserved.
*/

#ifndef KVISION_kG3D_POLYGONMASK_H
#define KVISION_kG3D_POLYGONMASK_H

#include <kVision/Common/kVision.h>
#include <kVision/S3d/kS3dCommon.h>

/**
* @class       kG3dPolygonMask
* @extends     kObject
* @ingroup     kVision-S3d
* @brief       Class for creating mask map from polygon input.
*              It is planned, to write more utilities for different applications, 
*              but currently there is only one function available.
*/
typedef kObject kG3dPolygonMask;

/**
* Constructs a kG3dPolygonMask object
*
* @public              @memberof kG3dPolygonMask
* @param   polyon       Destination for the constructed object handle.
* @param   allocator   Memory allocator (or kNULL for default).
* @return              Operation status.
*/
kVsFx(kStatus) kG3dPolygonMask_Construct(kG3dPolygonMask* polyon, kAlloc allocator);

/**
* creates a mask map from given polygons.
*
* @public                 @memberof kG3dPolygonMask
* @param   polyon         kG3dPolygonMask object.
* @param   data           Data buffer for output mask map.   kArray2 < k16s >
* @param   countour       Data buffer for input polygons     kArray1 < kPoint64f >
* @return                 Operation status.
*/
kVsFx(kStatus) kG3dPolygonMask_Run(kG3dPolygonMask polyon, kArray2 data, kArray1 countour, k16s bit);

/**
* Draws a Triangles on the mask map.
*
* @public                 @memberof kG3dPolygonMask
* @param   data           Data buffer for output mask map.   kArray2 < k16s >
* @param   P1             The first point
* @param   P2             The second point
* @param   P3             The third point
* @param   bit            Value to be drawn.
* @param   add            The pixel should be replaced or added.
* @return                 Operation status.
*/
kVsFx(kStatus) kG3dPolygonMask_FillPolygon3(kArray2 data, kPoint64f p1, kPoint64f p2, kPoint64f p3, k16s bit, kBool add);


#include <kVision/G3d/kG3dPolygonMask.x.h>

#endif  /* KVISION_kG3D_POLYGONMASK_H */
