#ifndef LMITECH_KVISION_L3D_ZCHARTPLOTTER_H_INCLUDED
#define LMITECH_KVISION_L3D_ZCHARTPLOTTER_H_INCLUDED

#include <kVision/Common/kPolynomial.h>
#include <stdio.h>
#include <string.h>
#include <math.h>

#define kL3D_CHART_PLOTTER_Y_MARGIN              (0.1)
#define kL3D_CHART_PLOTTER_X_MARGIN              (0.1)
#define kL3D_CHART_PLOTTER_EPS                   (1e-8)
#define kL3D_CHART_PLOTTER_DEFAULT_LINE_WIDTH    (1)
#define kL3D_CHART_PLOTTER_DEFAULT_POINT_SIZE    (3)

typedef struct kL3dChartPlotterClass 
{
    kObjectClass base;
    kPlot plot;
    kGraphic current; /* held layer */

    kArrayList pointsBuffer;

    kL3dTransform2d transform;
    kChar seriesName[256];
    kL3dChartPlotterCurveStyle curveStyle;
    k64f pointSize;
    k64f lineWidth;

    k64f minX;
    k64f maxX;
    k64f minY;
    k64f maxY;
} kL3dChartPlotterClass; 

kDeclareClassEx(kVs, kL3dChartPlotter, kObject)

kStatus kL3dChartPlotter_Init(kL3dChartPlotter plotter, kType type, kPlot plot, kAlloc alloc);
kVsFx(kStatus) kL3dChartPlotter_VRelease(kL3dChartPlotter plotter);

kStatus kL3dChartPlotter_ConstructLayer(kL3dChartPlotter plotter, const kChar* name, kGraphic* layer);

kStatus kL3dChartPlotter_Reset(kL3dChartPlotter plotter);

kStatus kL3dChartPlotter_TransformPoints(kL3dChartPlotter plotter, kPoint32f* points, kSize count);
kStatus kL3dChartPlotter_PlotPointBuffer(kL3dChartPlotter plotter, kSize count, kColor color, kL3dChartPlotterCurveStyle style);
kStatus kL3dChartPlotter_UpdateLimits(kL3dChartPlotter plotter, kPoint32f* points, kSize count);

#endif /* #ifndef LMITECH_KVISION_L3D_ZCHARTPLOTTER_H_INCLUDED */
