#ifndef LMITECH_KVISION_L3D_LUT_H_INCLUDED
#define LMITECH_KVISION_L3D_LUT_H_INCLUDED

#include <kVision/L3d/kL3dCommon.h>
#include <kVision/L3d/kL3dPolynomialArray.h>
#include <kVision/L3d/kL3dRangeCalData.h>

typedef kPointer kL3dLut;

typedef struct kL3dLutTransform 
{
    k32s xOffset;
    k32s xShift;

    k32s yOffset;
    k32s yShift;
} kL3dLutTransform;

typedef struct kL3dLutParams 
{
    k32u sourceWidth;
    k32u sourceHeight;
    k32u depth;

    kL3dLutTransform lutToSource;
    kL3dLutTransform inputToSource;

} kL3dLutParams;

typedef struct kL3dProfileLutParams 
{
    k32u  depth;
    kBool columnBased;

    k32u  centreStep;
    k32u  sliceStep;

    kL3dCameraWindow calWindow;
    kL3dCameraWindow runWindow;

} kL3dProfileLutParams;

typedef struct kL3dRangeCalDataInputParams 
{
    k32u centreCount;
    k32u centreStep;
    k32u centreOffset;

    k32u sliceCount;
    k32u sliceStep;
} kL3dRangeCalDataInputParams;

kVsFx(kStatus) kL3dLut_Construct(kL3dLut* lut, const kL3dLutParams* params, kAlloc allocator);

kVsFx(kStatus) kL3dLut_ImportPolynomialArray(kL3dLut* lut, const kL3dProfileLutParams* params, 
                            kArray1 centreBegin, kArray1 centreEnd, kL3dPolynomialArray* centreToF, k64f* scale, kAlloc allocator);

kVsFx(kStatus) kL3dLut_ImportRangeArray(kL3dLut* lut, const kL3dProfileLutParams* params, 
                            const kL3dRangeCalDataInputParams* inputParams, kArray1 centreBegin, kArray1 centreEnd,
                            kArray2* rangeArray, k64f* scale, kAlloc allocator);

kVsFx(k32u)    kL3dLut_Width(kL3dLut lut);
kVsFx(k32u)    kL3dLut_Height(kL3dLut lut);
kVsFx(k32u)    kL3dLut_Depth(kL3dLut lut);
kVsFx(kArray3) kL3dLut_Data(kL3dLut lut);
kVsFx(kStatus) kL3dLut_Clear(kL3dLut lut);

kVsFx(kStatus) kL3dLut_Evaluate(kL3dLut lut, kL3dLookupMethod method, k32s x, k32u y, k16s* f);

#define kL3D_LUT_EVALUATE_SINGULAR_LINEAR(LUT,X,Y,RESULT) kxL3D_LUT_EVALUATE_SINGULAR_LINEAR(LUT,X,Y,RESULT)
#define kL3D_LUT_EVALUATE_LINEAR_CUBIC(LUT,X,Y,RESULT)    kxL3D_LUT_EVALUATE_LINEAR_CUBIC(LUT,X,Y,RESULT)
#define kL3D_LUT_INDEX(LUT,X,Y,ROW,COLUMN,FRACTION)       kxL3D_LUT_INDEX(LUT,X,Y,ROW,COLUMN,FRACTION)
#define kL3D_LUT_INTERPOLATE(LUT,V0,V1,FRACTION)          kxL3D_LUT_INTERPOLATE(LUT,V0,V1,FRACTION)

#define kL3D_LUT_CLIP_VALUE(VALUE)                        kxL3D_LUT_CLIP_VALUE(VALUE)
#define kL3D_LUT_ROW_TO_SOURCE(LUT,ROW)                   kxL3D_LUT_ROW_TO_SOURCE(LUT,ROW)
#define kL3D_LUT_COLUMN_TO_SOURCE(LUT,COLUMN)             kxL3D_LUT_COLUMN_TO_SOURCE(LUT,COLUMN)
#define kL3D_LUT_X_MIN(LUT)                               kxL3D_LUT_X_MIN(LUT)
#define kL3D_LUT_X_MAX(LUT)                               kxL3D_LUT_X_MAX(LUT)
#define kL3D_LUT_HEIGHT(LUT)                              kxL3D_LUT_HEIGHT(LUT)
#define kL3D_LUT_WIDTH(LUT)                               kxL3D_LUT_WIDTH(LUT)
#define kL3D_LUT_DEPTH(LUT)                               kxL3D_LUT_DEPTH(LUT)
#define kL3D_LUT_CELL_AT(LUT,ROW,COLUMN)                  kxL3D_LUT_CELL_AT(LUT,ROW,COLUMN)

#include <kVision/L3d/kL3dLut.x.h>

#endif /* #ifndef LMITECH_KVISION_L3D_LUT_H_INCLUDED */
