#ifndef LMITECH_KVISION_L3D_XLUT_H_INCLUDED
#define LMITECH_KVISION_L3D_XLUT_H_INCLUDED

#include <kVision/Common/kNullMath.h>
#include <kFireSync/Data/kSpot.h>
#include <kVision/L3d/kL3dUtilities.h>
#include <math.h>

#define kL3D_LUT_CUBIC_QUANTIZATION         (8)


kDeclareValueEx(kVs, kL3dLutTransform, kValue)
kDeclareValueEx(kVs, kL3dLutParams, kValue)
kDeclareValueEx(kVs, kL3dProfileLutParams, kValue)
kDeclareValueEx(kVs, kL3dRangeCalDataInputParams, kValue)

typedef struct kL3dLutClass 
{
    kObjectClass base;

    kArray3 data;
    k16s* dataPoints;

    k32u width;
    k32u height;
    k32u depth;
    k32u rowStep;

    k32s xLutBegin;
    k32s xLutStep;
    k32s yLutBegin;
    k32s yLutStep;

    k32s xToColumnShift;
    k32s xScaledOffset;
    k32s xScaledWidth;
    k32u xFractionMask;

    k32s yToRowShift;
    k32s yScaledOffset;
    k32s yScaledHeight;
    k32u yFractionMask;

} kL3dLutClass;

kDeclareClassEx(kVs, kL3dLut, kObject)

kStatus kL3dLut_Init(kL3dLut lut, kType type, const kL3dLutParams* params, kAlloc allocator);
kVsFx(kStatus) kL3dLut_VRelease(kL3dLut lut);

#define kxL3D_LUT_CLIP_VALUE(VALUE)             ((((VALUE) > (k16S_MIN+1)) && ((VALUE) < (k16S_MAX-1))) ? (VALUE) : k16S_NULL)
#define kxL3D_LUT_ROW_TO_SOURCE(LUT,ROW)        (((kL3dLutClass*)(LUT))->yLutBegin + ((k32s)(ROW))*((kL3dLutClass*)(LUT))->yLutStep)
#define kxL3D_LUT_COLUMN_TO_SOURCE(LUT,COLUMN)  (((kL3dLutClass*)(LUT))->xLutBegin + ((k32s)(COLUMN))*((kL3dLutClass*)(LUT))->xLutStep)
#define kxL3D_LUT_X_MIN(LUT)                    (((kL3dLutClass*)(LUT))->xScaledOffset)
#define kxL3D_LUT_X_MAX(LUT)                    (((kL3dLutClass*)(LUT))->xScaledOffset + ((kL3dLutClass*)(LUT))->xScaledWidth)
#define kxL3D_LUT_HEIGHT(LUT)                   (((kL3dLutClass*)(LUT))->height)
#define kxL3D_LUT_WIDTH(LUT)                    (((kL3dLutClass*)(LUT))->width)
#define kxL3D_LUT_DEPTH(LUT)                    (((kL3dLutClass*)(LUT))->depth)

#define kxL3D_LUT_CELL_AT(LUT,ROW,COLUMN)                                                 \
        (((kL3dLutClass*)(LUT))->dataPoints + (ROW)*((kL3dLutClass*)(LUT))->rowStep +     \
                                (COLUMN)*((kL3dLutClass*)(LUT))->depth)                   \

#define kxL3D_LUT_INTERPOLATE(LUT,V0,V1,FRACTION) ((V0) + (((FRACTION)*((V1) - (V0))) >> ((kL3dLutClass*)(LUT))->xToColumnShift))

#define kxL3D_LUT_INDEX(LUT,X,Y,ROW,COLUMN,FRACTION)                                    \
    do                                                                                  \
    {                                                                                   \
        kObj(kL3dLut, LUT);                                                             \
        k32u lutScaledRow = ((k32s)(Y)) - obj->yScaledOffset;                           \
        k32u lutScaledColumn = ((k32s)(X)) - obj->xScaledOffset;                        \
        *(ROW) = (k32u)(lutScaledRow >> obj->yToRowShift);                              \
        *(COLUMN) = (k32u)(lutScaledColumn >> obj->xToColumnShift);                     \
        *(FRACTION) = (k32u)(lutScaledColumn & obj->xFractionMask);                     \
    } while(0);

#define kxL3D_LUT_EVALUATE_SINGULAR_LINEAR(LUT,X,Y,RESULT)                                          \
    do                                                                                              \
    {                                                                                               \
        kObj(kL3dLut, LUT);                                                                         \
        k32u lutScaledRow = ((k32s)(Y)) - obj->yScaledOffset;                                       \
        k32u lutRow = (k32u)(lutScaledRow >> obj->yToRowShift);                                     \
        k32u lutScaledColumn = ((k32s)(X)) - obj->xScaledOffset;                                    \
        k32u lutColumn = (k32u)(lutScaledColumn >> obj->xToColumnShift);                            \
        k32u lutColumnFraction = (lutScaledColumn & obj->xFractionMask);                            \
        k16s* outData = (RESULT);                                                                   \
        k16s* outDataEnd = outData + obj->depth;                                                    \
        k16s* lutData = obj->dataPoints + lutRow*obj->rowStep + lutColumn*obj->depth;               \
        if((lutRow < obj->height) && (lutColumn < (obj->width - 1)) &&                              \
                (lutData[0] != k16S_NULL) && (lutData[obj->depth] != k16S_NULL))                    \
        {                                                                                           \
            while(outData != outDataEnd)                                                            \
            {                                                                                       \
                *outData = (k16s)(lutData[0] + (lutColumnFraction * (lutData[obj->depth] -          \
                                        lutData[0]) >> obj->xToColumnShift));                       \
                lutData++;                                                                          \
                outData++;                                                                          \
            }                                                                                       \
        }                                                                                           \
        else                                                                                        \
        {                                                                                           \
            while(outData != outDataEnd)                                                            \
            {                                                                                       \
                *outData = k16S_NULL;                                                               \
                outData++;                                                                          \
            }                                                                                       \
        }                                                                                           \
    } while(0);                                                                       

#define kxL3D_LUT_EVALUATE_LINEAR_CUBIC(LUT,X,Y,RESULT)                                                     \
    do                                                                                                      \
    {                                                                                                       \
        kObj(kL3dLut, LUT);                                                                                 \
        k32u lutScaledRow = ((k32s)(Y)) - obj->yScaledOffset;                                               \
        k32u lutRow = (k32u)(lutScaledRow >> obj->yToRowShift);                                             \
        k32s lutRowFraction = (lutScaledRow & obj->yFractionMask);                                          \
        k32u lutScaledColumn = ((k32s)(X)) - obj->xScaledOffset;                                            \
        k32u lutColumn = (k32u)(lutScaledColumn >> obj->xToColumnShift);                                    \
        k32s lutColumnFraction = (lutScaledColumn & obj->xFractionMask);                                    \
        k32s lutRowResidue = 1 + obj->yFractionMask - lutRowFraction;                                       \
        k16s* outData = (RESULT);                                                                           \
        k16s* outDataEnd = outData + obj->depth;                                                            \
        if((lutColumn > 0) && (lutColumn < (obj->width - 2) && (lutRow < obj->height - 1)))                 \
        {                                                                                                   \
            k16s* lutData = obj->dataPoints + lutRow*obj->rowStep + (lutColumn - 1)*obj->depth;             \
            while(outData != outDataEnd)                                                                    \
            {                                                                                               \
                k16s y00 = lutData[0];                                                                      \
                k16s y01 = lutData[obj->depth];                                                             \
                k16s y02 = lutData[2 * obj->depth];                                                         \
                k16s y03 = lutData[3 * obj->depth];                                                         \
                k16s y10 = lutData[obj->rowStep];                                                           \
                k16s y11 = lutData[obj->rowStep + obj->depth];                                              \
                k16s y12 = lutData[obj->rowStep + 2 * obj->depth];                                          \
                k16s y13 = lutData[obj->rowStep + 3 * obj->depth];                                          \
                if((y00 != k16S_NULL) && (y01 != k16S_NULL) && (y02 != k16S_NULL) && (y03 != k16S_NULL) &&  \
                   (y10 != k16S_NULL) && (y11 != k16S_NULL) && (y12 != k16S_NULL) && (y13 != k16S_NULL))    \
                {                                                                                           \
                    k32s a00 = 2 * y01;                                                                     \
                    k32s a01 = y02 - y00;                                                                   \
                    k32s a02 = 6 * (y02 - y01) - (y03 - y01) - 2 * (y02 - y00);                             \
                    k32s a03 = -4 * (y02 - y01) + (y03 - y01) + (y02 - y00);                                \
                                                                                                            \
                    k32s a10 = 2 * y11;                                                                     \
                    k32s a11 = y12 - y10;                                                                   \
                    k32s a12 = 6 * (y12 - y11) - (y13 - y11) - 2 * (y12 - y10);                             \
                    k32s a13 = -4 * (y12 - y11) + (y13 - y11) + (y12 - y10);                                \
                                                                                                            \
                    k32s t0 = 1 << kL3D_LUT_CUBIC_QUANTIZATION;                                             \
                    k32s t = (t0 * lutColumnFraction) >> obj->xToColumnShift;                               \
                    k32s t2 = (t * t) >> kL3D_LUT_CUBIC_QUANTIZATION;                                       \
                    k32s t3 = (t2 * t) >> kL3D_LUT_CUBIC_QUANTIZATION;                                      \
                                                                                                            \
                    k32s v0 = (a00 * t0 + a01 * t + a02 * t2 + a03 * t3) >> 1;                              \
                    k32s v1 = (a10 * t0 + a11 * t + a12 * t2 + a13 * t3) >> 1;                              \
                                                                                                            \
                    k32s v = (lutRowResidue * v0 + lutRowFraction * v1)                                     \
                           >> (obj->yToRowShift + kL3D_LUT_CUBIC_QUANTIZATION);                             \
                                                                                                            \
                    *outData++ = (k16s)kL3D_LUT_CLIP_VALUE(v);                                              \
                }                                                                                           \
                else                                                                                        \
                {                                                                                           \
                    while(outData != outDataEnd)                                                            \
                    {                                                                                       \
                        *outData++ = k16S_NULL;                                                             \
                    }                                                                                       \
                }                                                                                           \
                lutData++;                                                                                  \
            }                                                                                               \
        }                                                                                                   \
        else                                                                                                \
        {                                                                                                   \
            while(outData != outDataEnd)                                                                    \
            {                                                                                               \
                *outData++ = k16S_NULL;                                                                     \
            }                                                                                               \
        }                                                                                                   \
    } while(0);

#endif /* #ifndef LMITECH_KVISION_L3D_XLUT_H_INCLUDED */
