#ifndef K_VISION_L3D_LUTWRITERLEGACYIMPL_X_H
#define K_VISION_L3D_LUTWRITERLEGACYIMPL_X_H

#define kL3D_LUT_WRITER_LEGACY_IMPL_MAX                         (k16S_MAX)
#define kL3D_LUT_WRITER_LEGACY_IMPL_LOCAL_RANGE_MAX             (k16S_MAX/2)
#define kL3D_LUT_WRITER_LEGACY_IMPL_LOCAL_COUNT                 (4)
#define kL3D_LUT_WRITER_LEGACY_IMPL_MIN                         (k16S_MIN+1)
#define kL3D_LUT_WRITER_LEGACY_IMPL_CLIP(VALUE)                 ((((VALUE) > (kL3D_LUT_WRITER_LEGACY_IMPL_MIN)) && ((VALUE) < (kL3D_LUT_WRITER_LEGACY_IMPL_MAX))) ? (VALUE) : k16S_NULL)
#define kL3D_LUT_WRITER_LEGACY_IMPL_IS_VALID(V)                 ((V) != (k16S_NULL))

#define kFPGA_LUT_EXTRA_COLUMN_COUNT                            (2)
#define kFPGA_LUT_EXTRA_ROW_COUNT_Z                             (kCAMERA_PL_LUT_X_REDUCTION * 2) 
#define kFPGA_LUT_EXTRA_ROW_COUNT_X                             (kCAMERA_PL_LUT_X_REDUCTION * 2) 
#define kL3D_LUT_WRITER_LEGACY_IMPL_X_REDUCTION                 (4)

typedef struct kL3dLutWriterLegacyImplClass 
{
    kObjectClass base;

    kCamera camera;
    kRangeLutCaps cameraDefaults;
    kL3dPolynomialArray centreToX;
    kL3dPolynomialArray centreToZ;
    k32u centroidStep;
    k32u sliceStep;
    k32s centroidOffset;

    k32u scaledCentroidCount;
    k32u scaledValidCount;
    k32u scaledSliceCount;

    k32u lutHeight;
    k32u lutWidth;

    k32u denseLutHeight;
    k32u denseLutWidth;

    kArray1 centreBeginCal;
    kArray1 centreEndCal;
    
    kArray2 xCal;
    kArray2 zCal;

    kArray2 xArray;
    kArray2 zArray;
    kArray2 validArray;

    kArray1 centreBegin;
    kArray1 centreEnd;

    kArray2 xLut;
    kArray2 zLut;
    kArray2 validLut;

    k64f centreBeginBound;
    k64f centreEndBound;

    k64f xScale;
    k64f zScale;

} kL3dLutWriterLegacyImplClass;

kDeclareClassEx(kVs, kL3dLutWriterLegacyImpl, kObject)

kVsFx(kStatus) kL3dLutWriterLegacyImpl_Init(kL3dLutWriterLegacyImpl writer, kCamera camera, kL3dSensorCal cal, kRangeLutCaps* lutCaps, kType type, kAlloc alloc);
kVsFx(kStatus) kL3dLutWriterLegacyImpl_VRelease(kL3dLutWriterLegacyImpl writer);

/**
 * @brief Given a polynomial calibration file, sample a populate a dense LUT
 * 
 * @param writer    LutWriter object handle
 * @param cal       Cal0 file created by running calibration
 * @return kStatus  kOK if successful, kERROR otherwise
 */
kVsFx(kStatus) kL3dLutWriterLegacyImpl_ImportPolyCal(kL3dLutWriterLegacyImpl writer, kL3dSensorCal cal);

/**
 * @brief ImportRangeCal is not implemented
 */
kVsFx(kStatus) kL3dLutWriterLegacyImpl_ImportRangeCal(kL3dLutWriterLegacyImpl writer, kL3dSensorCal cal);

/**
 * @brief Determine LUT Boundaries and step sizes, then extrapolate the LUT
 * 
 * @param writer    LutWriter object handle
 * @param roi       Desired FOV to constrain the boundaries, full camera dimensions used if kNULL is given
 * @return kStatus  kOK if successful, kERROR otherwise
 */
kVsFx(kStatus) kL3dLutWriterLegacyImpl_Prepare(kL3dLutWriterLegacyImpl writer, const kRect64f* roi);

/**
 * @brief Determine LUT Boundaries and step sizes, then extrapolate the LUT
 * 
 * @param writer    LutWriter object handle
 * @param roi       Desired FOV to constrain the boundaries, full camera dimensions used if kNULL is given
 * @return kStatus  kOK if successful, kERROR otherwise
 */
kVsFx(kStatus) kL3dLutWriterLegacyImpl_CalculateBounds(kL3dLutWriterLegacyImpl writer,  const kRect64f* roi);

/**
 * @brief Determine the min and max centroid value from the centre begin and centre end
 * 
 * @param writer    LutWriter object handle
 * @return kStatus  kOK if successful, kERROR otherwise
 */
kVsFx(kStatus) kL3dLutWriterLegacyImpl_CalculateCentroidBounds(kL3dLutWriterLegacyImpl writer);

/**
 * @brief Based on the min and max centroid value determine the smallest step size that would fit the LUT
 * 
 * @param writer    LutWriter object handle
 * @return kStatus  kOK if successful, kERROR otherwise
 */
kVsFx(kStatus) kL3dLutWriterLegacyImpl_CalculateSteps(kL3dLutWriterLegacyImpl writer);

/**
 * @brief Copy centre begin and centre ends
 * 
 * @param writer    LutWriter object handle
 * @return kStatus  kOK if successful, kERROR otherwise
 */
kVsFx(kStatus) kL3dLutWriterLegacyImpl_CopyBounds(kL3dLutWriterLegacyImpl writer);

/**
 * @brief Extrapolate the LUT and then subsample based on step size
 * 
 * @param writer    LutWriter object handle
 * @return kStatus  kOK if successful, kERROR otherwise
 */
kVsFx(kStatus) kL3dLutWriterLegacyImpl_CreateLuts(kL3dLutWriterLegacyImpl writer);

/**
 * @brief Perform linear extrapolation along slices of the LUT
 * 
 * @param writer        LutWriter object handle
 * @param data          Pointer to calibration table data
 * @param rowLength     Length of slice dimension
 * @param columnLength  Length of centroid dimension
 * @param extraBefore   Number of times to extrapolate before
 * @param extraAfter    Number of times to extrapolate after
 * @return kStatus      kOK if successful, kERROR otherwise
 */
kVsFx(kStatus) kL3dLutWriterLegacyImpl_ExtrapolateLinear(kL3dLutWriterLegacyImpl writer, k64f* data, k32u length0, k32u length1, k32u incr0, k32u incr1, k32u extraBefore, k32u extraAfter);


/**
 * @brief Perform cubic extrapolation along centroids of the LUT
 * 
 * @param writer        LutWriter object handle
 * @param data          Pointer to calibration table data
 * @param rowLength     Length of slice dimension
 * @param columnLength  Length of centroid dimension
 * @param extraBefore   Number of times to extrapolate before
 * @param extraAfter    Number of times to extrapolate after
 * @return kStatus      kOK if successful, kERROR otherwise
 */
kVsFx(kStatus) kL3dLutWriterLegacyImpl_ExtrapolateCubic(kL3dLutWriterLegacyImpl writer, k64f* data, k32u length0, k32u length1, k32u incr0, k32u incr1, k32u extraBefore, k32u extraAfter);

kVsFx(kStatus) kL3dLutWriterLegacyImpl_Combine(kL3dLutWriterLegacyImpl writer, kArray2 array0, kArray2 array1, kArray2 arrayOut);

/**
 * @brief Given transform and resolutions, calculate and scale the extrapolated LUT to fit FPGA bitsizes 
 * 
 * @param writer        LutWriter object handle
 * @param transform     Transformation matrix
 * @param xScale        X resolution passed in as 1/xResolution
 * @param zScale        Z resolution passed in as 1/zResolution
 * @return kStatus      kOK if successful, kERROR otherwise
 */
kVsFx(kStatus) kL3dLutWriterLegacyImpl_Populate(kL3dLutWriterLegacyImpl writer, const kL3dTransform2d* transform, k64f xScale, k64f zScale);

/**
 * @brief Determine which LUT entries are required or valid to maximize resolution based on FOV
 * 
 * @param writer        LutWriter object handle
 * @param xMin          FOV x min
 * @param xMax          FOV x max
 * @param zMin          FOV z min
 * @param zMax          FOV z max
 * @return kStatus      kOK if successful, kERROR otherwise
 */
kVsFx(kStatus) kL3dLutWriterLegacyImpl_UpdateValid(kL3dLutWriterLegacyImpl writer, k64f xMin, k64f xMax, k64f zMin, k64f zMax);

/**
 * @brief Calculate resolution scale to use after valid range is determined from FOV
 * 
 * @param writer        LutWriter object handle
 * @param transform     Transformation matrix
 * @param xScale        Output x resolution
 * @param zScale        Output z resolution
 * @return kStatus      kOK if successful, kERROR otherwise
 */
kVsFx(kStatus) kL3dLutWriterLegacyImpl_EvaluateScales(kL3dLutWriterLegacyImpl writer, const kL3dTransform2d* transform, k64f* xScale, k64f* zScale);

/**
 * @brief Generate plot of the LUT values and valid range look up spots
 * 
 * @param writer        LutWriter object handle
 * @param output        Output plot
 * @return kStatus      kOK if successful, kERROR otherwise
 */
kVsFx(kStatus) kL3dLutWriterLegacyImpl_GenerateLutPlot(kL3dLutWriterLegacyImpl writer, kPlot* output);

/**
 * @brief Given the spot slice and centre, perform cubic linear interpolation to get ranges
 * 
 * @param writer        LutWriter object handle
 * @param lut           Z or X Lut object
 * @param slice0        Slice before the spot as a LUT index
 * @param slice1        Slice after the spot as a LUT index
 * @param lutCentre     Nearest LUT index in centroid direction rounded down
 * @param x             Raw spot slice value
 * @param y             Raw spot centroid value
 * @param scale         Z or X resolution
 * @param output        Resulting Z or X range
 * @return kBool        kTRUE if range look up succeeded, kFALSE otherwise
 */
kVsFx(kBool) kL3dLutWriterLegacyImpl_EvaluateLutCubicLinear(kL3dLutWriterLegacyImpl writer, kArray2 lut, k32s slice0, k32s slice1, k32s lutCentre, k64f x, k64f y, k64f scale, k64f* output);

#endif /* #ifndef K_VISION_L3D_LUTWRITERLEGACYIMPL_X_H */