#ifndef LMITECH_KVISION_L3D_ZPOLYNOMIALCALDATA_H_INCLUDED
#define LMITECH_KVISION_L3D_ZPOLYNOMIALCALDATA_H_INCLUDED

#include <kVision/L3d/kL3dCalData.h>
#include <kVision/L3d/kL3dPolynomial.h>
#include <kApi/Data/kArray2.h>

typedef struct kL3dPolynomialCalDataClass 
{
    kL3dCalDataClass base;

    kArray2 centreToX;
    kArray2 centreToY;
    kArray2 centreToZ;
} kL3dPolynomialCalDataClass;

kDeclareClassEx(kVs, kL3dPolynomialCalData, kL3dCalData)

kVsFx(kStatus) kL3dPolynomialCalData_Init(kL3dPolynomialCalData data, kType type, k32u count, k32u maxXOrder, k32u maxYOrder, k32u maxZOrder, kAlloc allocator);
kStatus kL3dPolynomialCalData_Read(kL3dPolynomialCalData data, kDataTree tree, kDataTreeItem item);

kVsFx(kStatus) kL3dPolynomialCalData_VRelease(kL3dPolynomialCalData data);
kStatus kL3dPolynomialCalData_Release(kL3dPolynomialCalData data);

kVsFx(kStatus) kL3dPolynomialCalData_VAssign(kL3dPolynomialCalData data, kL3dPolynomialCalData source);
kVsFx(kStatus) kL3dPolynomialCalData_VStore(kL3dPolynomialCalData data, kDataTree tree, kDataTreeItem item);
kVsFx(kL3dCalDataType) kL3dPolynomialCalData_VType(kL3dPolynomialCalData data);

kStatus kL3dPolynomialCalData_Clear(kL3dPolynomialCalData data);

#endif /* #ifndef LMITECH_KVISION_L3D_ZPOLYNOMIALCALDATA_H_INCLUDED */
