#ifndef LMITECH_KVISION_L3D_PROFILER_H_INCLUDED
#define LMITECH_KVISION_L3D_PROFILER_H_INCLUDED

#include <kVision/L3d/kL3dSensorCal.h>
#include <kFireSync/Data/kSpot.h>

typedef kPointer kL3dProfiler;

typedef struct kL3dProfilerParams 
{
    kL3dLookupMethod lookup;
    kL3dCameraWindow window;

    kBool columnBased;
    k64f  xResolution;
    k64f  yResolution;
    k64f  zResolution;
    k32u  channelCount;

    kRect3d64f fov;
} kL3dProfilerParams;

typedef struct kL3dProfilerLineParams 
{
    k32u index;
    k32u centreStep;
    k32u sliceStep;
} kL3dProfilerLineParams;

kVsFx(kStatus) kL3dProfiler_Construct(kL3dProfiler* profiler, const kL3dProfilerParams* params, kL3dSensorCal cal, kArrayList lineParams);
kVsFx(kStatus) kL3dProfiler_Destroy(kL3dProfiler profiler);

kVsFx(kStatus) kL3dProfiler_LookupSpots(kL3dProfiler profiler, const kSpot* spots, k32u spotCount, kArrayList inputLines, kArray2 ranges);
kVsFx(kStatus) kL3dProfiler_LookupFpgaSpots(kL3dProfiler profiler, const kFpgaSpot* spots, k32u spotCount, kArrayList inputLines, kArray2 ranges);

#endif /* #ifndef LMITECH_KVISION_L3D_PROFILER_H_INCLUDED */
