#ifndef LMITECH_KVISION_L3D_RANGECALDATA_H_INCLUDED
#define LMITECH_KVISION_L3D_RANGECALDATA_H_INCLUDED

#include <kVision/L3d/kL3dCalData.h>
#include <kFireSync/Data/kDataTree.h>

/**
* @class   kL3dRangeCalData
* @extends kL3dCalData
* @ingroup kVision-kL3d
* @brief
*/

typedef kL3dCalData kL3dRangeCalData;

typedef enum
{
    kL3D_RANGE_CAL_DATA_CHANNEL_Z = 0x01,
    kL3D_RANGE_CAL_DATA_CHANNEL_X = 0x02,
    kL3D_RANGE_CAL_DATA_CHANNEL_Y = 0x04
} kL3dRangeCalDataChannel;

typedef struct kL3dRangeCalDataParams 
{
    kL3dRangeCalDataChannel channelMask;

    k32u centreCount;
    k32u centreStep;
    k32u centreOffset;

    k32u sliceCount;
    k32u sliceStep;
} kL3dRangeCalDataParams;

/**
* Constructs a kL3dRangeCalData object.
*
* @public              @memberof kL3dRangeCalData
* @param   calData     Receives the constructed object.
* @param   params      Struct containing construction parameters.
* @param   allocator   Memory allocator (or kNULL for default).
* @return              Operation status.
*/
kVsFx(kStatus) kL3dRangeCalData_Construct(kL3dRangeCalData* calData, kL3dRangeCalDataParams* params, kAlloc allocator);

/**
* Constructs a kL3dRangeCalData object from a kDataTree.
*
* @public              @memberof kL3dRangeCalData
* @param   calData     A constructed kL3dRangeCalData object.
* @param   tree        Tree object.
* @param   item        Tree item.
* @return              Operation status.
*/
kVsFx(kStatus) kL3dRangeCalData_Import(kL3dRangeCalData* calData, kDataTree tree, kDataTreeItem item, kAlloc allocator);

kVsFx(k32u) kL3dRangeCalData_CentreCount(kL3dRangeCalData calData);
kVsFx(k32u) kL3dRangeCalData_CentreStep(kL3dRangeCalData calData);
kVsFx(k32u) kL3dRangeCalData_CentreOffset(kL3dRangeCalData calData);

kVsFx(k32u) kL3dRangeCalData_SliceCount(kL3dRangeCalData calData);
kVsFx(k32u) kL3dRangeCalData_SliceStep(kL3dRangeCalData calData);

kVsFx(kBool)   kL3dRangeCalData_HasChannel(kL3dRangeCalData calData, kL3dRangeCalDataChannel channel);
kVsFx(kArray2) kL3dRangeCalData_ChannelAt(kL3dRangeCalData calData, kL3dRangeCalDataChannel channel);

#include <kVision/L3d/kL3dRangeCalData.x.h>

#endif /* #ifndef LMITECH_KVISION_L3D_RANGECALDATA_H_INCLUDED */
