#ifndef LMITECH_KVISION_L3D_RANGESBLOCKINFO_H_INCLUDED
#define LMITECH_KVISION_L3D_RANGESBLOCKINFO_H_INCLUDED 

#include <kVision/L3d/kL3dCommon.h>

#define kL3D_RANGES_BLOCK_NAME                "3D_Ranges"
#define kL3D_RANGES_BLOCK_TYPE_NAME           "kL3dRangesBlock"

#define kL3D_RANGES_BLOCK_INSPOTS_NAME        "InSpots"
#define kL3D_RANGES_BLOCK_OUTRANGES_NAME      "OutRanges"
#define kL3D_RANGES_BLOCK_OUTPLOT_XY_NAME     "OutPlotXY"
#define kL3D_RANGES_BLOCK_OUTPLOT_XZ_NAME     "OutPlotXZ"

typedef enum
{
    kL3D_RANGES_BLOCK_OUTRANGES      = 0,
    kL3D_RANGES_BLOCK_OUTPLOT_XY     = 1,
    kL3D_RANGES_BLOCK_OUTPLOT_XZ     = 2,
    kL3D_RANGES_BLOCK_INSPOTS_BEGIN  = 3
} kL3dRangesBlockPort;

typedef struct kL3dRangesBlockLineInfo 
{
    k32u centreStep;
    k32u sliceStep;
    k32u id;
} kL3dRangesBlockLineInfo;

typedef kObject kL3dRangesBlockInfo;

kVsFx(kStatus) kL3dRangesBlockInfo_Construct(kL3dRangesBlockInfo* info, k32u stateCount, k32u lineCount, kAlloc allocator);
kVsFx(kStatus) kL3dRangesBlockInfo_Load(kL3dRangesBlockInfo* info, kXml xml, kAlloc allocator);

kVsFx(kStatus) kL3dRangesBlockInfo_Store(kL3dRangesBlockInfo info, kXml* xml, kAlloc allocator);

kVsFx(kStatus) kL3dRangesBlockInfo_Read(kL3dRangesBlockInfo info, kXml xml, kXmlItem item);
kVsFx(kStatus) kL3dRangesBlockInfo_Write(kL3dRangesBlockInfo info, kXml xml, kXmlItem item);

kVsFx(kSize) kL3dRangesBlockInfo_StateCount(kL3dRangesBlockInfo info);
kVsFx(kSize) kL3dRangesBlockInfo_LineCount(kL3dRangesBlockInfo info);
kVsFx(kArrayList) kL3dRangesBlockInfo_StateLines(kL3dRangesBlockInfo info, k32u stateIndex);
kVsFx(k32u) kL3dRangesBlockInfo_StateId(kL3dRangesBlockInfo info, k32u stateIndex);

kVsFx(const kChar*) kL3dRangesBlockInfo_CalFileName(kL3dRangesBlockInfo info);
kVsFx(const kL3dCameraWindow*) kL3dRangesBlockInfo_RunWindow(kL3dRangesBlockInfo info);
kVsFx(const kRect3d64f*) kL3dRangesBlockInfo_Fov(kL3dRangesBlockInfo info);

kVsFx(k64f) kL3dRangesBlockInfo_XResolution(kL3dRangesBlockInfo info);
kVsFx(k64f) kL3dRangesBlockInfo_YResolution(kL3dRangesBlockInfo info);
kVsFx(k64f) kL3dRangesBlockInfo_ZResolution(kL3dRangesBlockInfo info);
kVsFx(kBool) kL3dRangesBlockInfo_IsColumnBased(kL3dRangesBlockInfo info);
kVsFx(kL3dLookupMethod) kL3dRangesBlockInfo_LookupMethod(kL3dRangesBlockInfo info);
kVsFx(k32u) kL3dRangesBlockInfo_ChannelCount(kL3dRangesBlockInfo info);
kVsFx(kBool) kL3dRangesBlockInfo_IsFovClippingEnabled(kL3dRangesBlockInfo info);
kVsFx(kL3dRangesBlockLineInfo*) kL3dRangesBlockInfo_LineInfo(kL3dRangesBlockInfo info, k32u lineIndex);

kVsFx(kStatus) kL3dRangesBlockInfo_SetStateLines(kL3dRangesBlockInfo info, k32u stateIndex, k32u* ids, k32u count);
kVsFx(kStatus) kL3dRangesBlockInfo_SetStateId(kL3dRangesBlockInfo info, k32u stateIndex, k32u id);
kVsFx(kStatus) kL3dRangesBlockInfo_SetCalFileName(kL3dRangesBlockInfo info, const kChar* calFileName);
kVsFx(kStatus) kL3dRangesBlockInfo_SetRunWindow(kL3dRangesBlockInfo info, const kL3dCameraWindow* window);
kVsFx(kStatus) kL3dRangesBlockInfo_SetFov(kL3dRangesBlockInfo info, const kRect3d64f* fov);
kVsFx(kStatus) kL3dRangesBlockInfo_SetXResolution(kL3dRangesBlockInfo info, k64f resolution);
kVsFx(kStatus) kL3dRangesBlockInfo_SetYResolution(kL3dRangesBlockInfo info, k64f resolution);
kVsFx(kStatus) kL3dRangesBlockInfo_SetZResolution(kL3dRangesBlockInfo info, k64f resolution);
kVsFx(kStatus) kL3dRangesBlockInfo_SetColumnBased(kL3dRangesBlockInfo info, kBool columnBased);
kVsFx(kStatus) kL3dRangesBlockInfo_SetLookupMethod(kL3dRangesBlockInfo info, kL3dLookupMethod lookupMethod);
kVsFx(kStatus) kL3dRangesBlockInfo_SetChannelCount(kL3dRangesBlockInfo info, k32u count);
kVsFx(kStatus) kL3dRangesBlockInfo_EnableFovClipping(kL3dRangesBlockInfo info, kBool enable);
kVsFx(kStatus) kL3dRangesBlockInfo_SetLineInfo(kL3dRangesBlockInfo info, k32u lineIndex, const kL3dRangesBlockLineInfo* line);

#include <kVision/L3d/kL3dRangesBlockInfo.x.h>

#endif /* #ifndef LMITECH_KVISION_L3D_RANGESBLOCKINFO_H_INCLUDED */
