#ifndef LMITECH_KVISION_L3D_ZRANGESBLOCKINFO_H_INCLUDED
#define LMITECH_KVISION_L3D_ZRANGESBLOCKINFO_H_INCLUDED 

#include <kVision/L3d/kL3dUtilities.h>
#include <kVision/L3d/kL3dValueList.h>
#include <kApi/Data/kArrayList.h>
#include <kApi/Data/kBytes.h>
#include <kApi/Data/kXml.h>
#include <string.h>

typedef struct kL3dRangesBlockInfoState 
{
    kArrayList lines;
    k32u id;
} kL3dRangesBlockInfoState;

typedef struct kL3dRangesBlockInfoClass 
{
    kObjectClass base;

    kText256 calFileName;
    kL3dCameraWindow runWindow;
    kRect3d64f   fov;
    k64f xResolution;
    k64f yResolution;
    k64f zResolution;

    kL3dLookupMethod lookupMethod;
    kBool columnBased;
    kBool clipFov;
    k32u  channelCount;
    kArrayList states;
    kArrayList lines;
} kL3dRangesBlockInfoClass;

kDeclareClassEx(kVs, kL3dRangesBlockInfo, kObject)

kStatus kL3dRangesBlockInfo_Init(kL3dRangesBlockInfo info, kType type, k32u stateCount, k32u lineCount, kAlloc allocator);
kVsFx(kStatus) kL3dRangesBlockInfo_VRelease(kL3dRangesBlockInfo info);
kStatus kL3dRangesBlockInfo_InitArrayLists(kL3dRangesBlockInfo info, k32u stateCount, k32u lineCount, kAlloc allocator);
kStatus kL3dRangesBlockInfo_Release(kL3dRangesBlockInfo info);

#endif /* #ifndef LMITECH_KVISION_L3D_ZRANGESBLOCKINFO_H_INCLUDED */
