/**
* @file    kL3dSegmentSortBlockInfo.x.h
*
* @internal
* Copyright (C) 2014-2022 by LMI Technologies Inc. All rights reserved.
*/
#ifndef LMITECH_KVISION_L3D_SEGMENT_SORT_BLOCK_INFO_X_H_INCLUDED
#define LMITECH_KVISION_L3D_SEGMENT_SORT_BLOCK_INFO_X_H_INCLUDED

typedef struct kL3dSegmentSortBlockInfoClass
{
    kObjectClass base;

    kSize columnCount;

    kSize centreRange;
    kSize centreMargin;
    kSize sliceMargin;

    kSize segmentCapacity;
    kSize minSegmentLength;
    kSize minSegmentSpotCount;
    kBool resolveSpotOverlap;

} kL3dSegmentSortBlockInfoClass;

kDeclareClassEx(kVs, kL3dSegmentSortBlockInfo, kObject)

kVsFx(kStatus) kL3dSegmentSortBlockInfo_Init(kL3dSegmentSortBlockInfo info, kType type, kAlloc alloc);
kVsFx(kStatus) kL3dSegmentSortBlockInfo_VRelease(kL3dSegmentSortBlockInfo info);


kVsFx(kStatus) kL3dSegmentSortBlockInfo_SetOverlapThreshold(kL3dSegmentSortBlockInfo info, kSize threshold);
kVsFx(kSize) kL3dSegmentSortBlockInfo_OverlapThreshold(kL3dSegmentSortBlockInfo info);

#endif
