#ifndef LMITECH_KVISION_L3D_SPOTSBLOCKINFO_H_INCLUDED
#define LMITECH_KVISION_L3D_SPOTSBLOCKINFO_H_INCLUDED 

#include <kVision/L3d/kL3dCommon.h>
#include <kFireSync/Client/Camera/Algorithms/kAcgInfo.h>

#define kL3D_SPOTS_BLOCK_NAME                 "3D_Spots"
#define kL3D_SPOTS_BLOCK_TYPE_NAME            "kL3dSpotsBlock"

#define kL3D_SPOTS_BLOCK_INFPGA_NAME          "InFPGA"
#define kL3D_SPOTS_BLOCK_OUTSPOTS_NAME        "OutSpots"
#define kL3D_SPOTS_BLOCK_OUTPLOT_NAME         "OutPlot"

typedef enum
{
    kL3D_SPOTS_BLOCK_INFPGA   = 0,
    kL3D_SPOTS_BLOCK_OUTSPOTS = 1,
    kL3D_SPOTS_BLOCK_OUTPLOT  = 2
} kL3dSpotsBlockPort;

typedef enum
{
    kL3D_SPOTS_BLOCK_ALG_TYPE_ACG    = 0,
    kL3D_SPOTS_BLOCK_ALG_TYPE_SOBEL  = 1
} kL3dSpotsBlockAlgType;

typedef kObject kL3dSpotsBlockInfo;

kVsFx(kStatus)          kL3dSpotsBlockInfo_Construct(kL3dSpotsBlockInfo * info, kAlloc allocator);
kVsFx(kStatus)          kL3dSpotsBlockInfo_Load(kL3dSpotsBlockInfo * info, kXml xml, kAlloc allocator);
kVsFx(kStatus)          kL3dSpotsBlockInfo_Store(kL3dSpotsBlockInfo info, kXml* xml, kAlloc allocator);
                        
kVsFx(kStatus)          kL3dSpotsBlockInfo_Read(kL3dSpotsBlockInfo info, kXml xml, kXmlItem item);
kVsFx(kStatus)          kL3dSpotsBlockInfo_Write(kL3dSpotsBlockInfo info, kXml xml, kXmlItem item);
                        
kVsFx(k32u)             kL3dSpotsBlockInfo_Threshold(kL3dSpotsBlockInfo info);
kVsFx(k32u)             kL3dSpotsBlockInfo_WidthThreshold(kL3dSpotsBlockInfo info);
kVsFx(k32u)             kL3dSpotsBlockInfo_MinSpotWidth(kL3dSpotsBlockInfo info);
kVsFx(k32u)             kL3dSpotsBlockInfo_MaxSpotWidth(kL3dSpotsBlockInfo info);
kVsFx(k32u)             kL3dSpotsBlockInfo_MaxSpots(kL3dSpotsBlockInfo info);
kVsFx(kBool)            kL3dSpotsBlockInfo_IsColumnBased(kL3dSpotsBlockInfo info);
kVsFx(k32u)             kL3dSpotsBlockInfo_ImageWidth(kL3dSpotsBlockInfo info);
kVsFx(k32u)             kL3dSpotsBlockInfo_ImageHeight(kL3dSpotsBlockInfo info);
kVsFx(k32u)             kL3dSpotsBlockInfo_SpotAlgorithm(kL3dSpotsBlockInfo info);
kVsFx(k32u)             kL3dSpotsBlockInfo_SobelEdgeWindow(kL3dSpotsBlockInfo info);
kVsFx(k32u)             kL3dSpotsBlockInfo_SobelAverageWindow(kL3dSpotsBlockInfo info);
kVsFx(k32u)             kL3dSpotsBlockInfo_MinSum(kL3dSpotsBlockInfo info);
kVsFx(kL3dSpotType)     kL3dSpotsBlockInfo_OutputSpotType(kL3dSpotsBlockInfo info);
kVsFx(kAcgSpotFormat)   kL3dSpotsBlockInfo_SpotFormat(kL3dSpotsBlockInfo info);
kVsFx(kBool)            kL3dSpotsBlockInfo_EntryDebounceEnabled(kL3dSpotsBlockInfo info);
kVsFx(k32u)             kL3dSpotsBlockInfo_ExitIntensityThreshold(kL3dSpotsBlockInfo info);
                        
kVsFx(kStatus)          kL3dSpotsBlockInfo_SetThreshold(kL3dSpotsBlockInfo info, k32u threshold);
kVsFx(kStatus)          kL3dSpotsBlockInfo_SetWidthThreshold(kL3dSpotsBlockInfo info, k32u widthThreshold);
kVsFx(kStatus)          kL3dSpotsBlockInfo_SetMinSpotWidth(kL3dSpotsBlockInfo info, k32u spotWidth);
kVsFx(kStatus)          kL3dSpotsBlockInfo_SetMaxSpotWidth(kL3dSpotsBlockInfo info, k32u spotWidth);
kVsFx(kStatus)          kL3dSpotsBlockInfo_SetMaxSpots(kL3dSpotsBlockInfo info, k32u maxSpots);
kVsFx(kStatus)          kL3dSpotsBlockInfo_SetColumnBased(kL3dSpotsBlockInfo info, kBool columnBased);
kVsFx(kStatus)          kL3dSpotsBlockInfo_SetImageWidth(kL3dSpotsBlockInfo info, k32u imageWidth);
kVsFx(kStatus)          kL3dSpotsBlockInfo_SetImageHeight(kL3dSpotsBlockInfo info, k32u imageHeight);
kVsFx(kStatus)          kL3dSpotsBlockInfo_SetSpotAlgorithm(kL3dSpotsBlockInfo info, k32u spotAlgorithm);
kVsFx(kStatus)          kL3dSpotsBlockInfo_SetSobelEdgeWindow(kL3dSpotsBlockInfo info, k32u sobelEdgeWindow);
kVsFx(kStatus)          kL3dSpotsBlockInfo_SetSobelAverageWindow(kL3dSpotsBlockInfo info, k32u sobelAverageWindow);
kVsFx(kStatus)          kL3dSpotsBlockInfo_SetMinSum(kL3dSpotsBlockInfo info, k32u minSum);
kVsFx(kStatus)          kL3dSpotsBlockInfo_SetOutputSpotType(kL3dSpotsBlockInfo info, kL3dSpotType spotType);
kVsFx(kStatus)          kL3dSpotsBlockInfo_SetSpotFormat(kL3dSpotsBlockInfo info, kAcgSpotFormat spotFormat);
kVsFx(kStatus)          kL3dSpotsBlockInfo_EnableEntryDebounce(kL3dSpotsBlockInfo info, kBool entryDebounceEnabled);
kVsFx(kStatus)          kL3dSpotsBlockInfo_SetExitIntensityThreshold(kL3dSpotsBlockInfo info, k32u exitIntensityThreshold);

#include <kVision/L3d/kL3dSpotsBlockInfo.x.h>

#endif /* #ifndef LMITECH_KVISION_L3D_SPOTSBLOCKINFO_H_INCLUDED */
