/**
 * @file kMp3dSensorCal.x.h
 *
 * @internal
 * Copyright (C) 2016-2022 by LMI Technologies Inc.  All rights reserved.
 */

#ifndef K_VISION_MP3D_SENSOR_CAL_X_H
#define K_VISION_MP3D_SENSOR_CAL_X_H

/**
 * Reserved kMp3dSensorCal macros.
 *
 * @relates kMp3dSensorCal
 * @{ */
#define kMP3D_SENSOR_CAL_VERSION                            (1)
/** @} */

typedef struct kMp3dSensorCalTempEntry 
{
    kArray2 row;
    kArray2 col;
    k64f z;
    k64f temperature;
} kMp3dSensorCalTempEntry;

typedef struct kMp3dSensorCalViewData 
{
    kL3dCameraWindow calWindow;
    kArrayList tempEntries;
    kArray2 x;
    kArray2 z;
    kArray2 row;
    kArray2 col;
    kArray2 xPerspectiveScales;
    kArray2 yPerspectiveScales;

} kMp3dSensorCalViewData;

typedef struct kMp3dSensorCalClass
{
    kObjectClass base;

    k32u id;
    kString timestamp;

    kSize viewCount;
    kSize stepCount;
    kSize viewLightCount;
    kSize lightSpotCount;
    k64f temperature;

    kArray1 viewData;

} kMp3dSensorCalClass;

kDeclareClassEx(kVs, kMp3dSensorCal, kObject)

kStatus kMp3dSensorCal_Init(kMp3dSensorCal cal, kSize stepCount, kSize viewCount, kSize viewLightCount, kSize lightSpotCount, kSize windowWidth, kSize windowHeight, kAlloc allocator);
kVsFx(kBool) kMp3dSensorCal_VEquals(kMp3dSensorCal cal, kMp3dSensorCal otherCal);
kVsFx(kStatus) kMp3dSensorCal_VRelease(kMp3dSensorCal cal);
kStatus kMp3dSensorCal_Read(kMp3dSensorCal cal, kDataTree tree, kDataTreeItem item, kAlloc allocator);
kStatus kMp3dSensorCal_Write(kMp3dSensorCal cal, kDataTree tree, kDataTreeItem item);
kVsFx(kArray2) kMp3dSensorCal_Z(kMp3dSensorCal cal, kSize viewIndex);
kVsFx(kArray2) kMp3dSensorCal_X(kMp3dSensorCal cal, kSize viewIndex);
kVsFx(kArray2) kMp3dSensorCal_Row(kMp3dSensorCal cal, kSize viewIndex);
kVsFx(kArray2) kMp3dSensorCal_Col(kMp3dSensorCal cal, kSize viewIndex);
kVsFx(kArray2) kMp3dSensorCal_XPerspectiveScale(kMp3dSensorCal cal, kSize viewIndex);
kVsFx(kArray2) kMp3dSensorCal_YPerspectiveScale(kMp3dSensorCal cal, kSize viewIndex);

#endif /* #ifndef K_VISION_MP3D_SENSOR_CAL_X_H */

