/** 
 * @file    kP3dLutActionInfo.x.h
 * 
 * @internal
 * Copyright (C) 2014-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef LMITECH_KVISION_P3D_LUT_ACTION_INFO_X_H_INCLUDED
#define LMITECH_KVISION_P3D_LUT_ACTION_INFO_X_H_INCLUDED

#include <kVision/P3d/kP3dSensorCal.h>

typedef struct kP3dLutActionInfoClass
{
    kObjectClass base; 

    k32u viewIndex;
    kText256 calFileName;

    k32s testPattern;
    k32u intensityMultiplier;

    k64f rangeScale;

    kL3dTransform2d transform;

    kBool exportLut;

} kP3dLutActionInfoClass; 

kDeclareClassEx(kVs, kP3dLutActionInfo, kObject)

kVsFx(kStatus) kP3dLutActionInfo_Init(kP3dLutActionInfo info, kType type, kAlloc alloc);
kVsFx(kStatus) kP3dLutActionInfo_VRelease(kP3dLutActionInfo info);

#endif
