#ifndef LMITECH_KVISION_S3D_AUTOEXPOSE_H_INCLUDED
#define LMITECH_KVISION_S3D_AUTOEXPOSE_H_INCLUDED

#include <kVision/S3d/kS3dCommon.h>
#include <kVision/L3d/kL3dCommon.h>
#include <kFireSync/Data/kPlot.h>

typedef kPointer kS3dAutoExpose;

typedef enum
{
    kS3D_AUTO_EXPOSE_RUNNING,
    kS3D_AUTO_EXPOSE_SUCCESS,
    kS3D_AUTO_EXPOSE_ITERATION_LIMIT_REACHED
} kS3dAutoExposeStatus;

kVsFx(kStatus) kS3dAutoExpose_Construct(kS3dAutoExpose* autoExpose, k32u viewCount, k32u exposureMin, k32u exposureMax);
kVsFx(kStatus) kS3dAutoExpose_Destroy(kS3dAutoExpose autoExpose);

kVsFx(kStatus) kS3dAutoExpose_Reset(kS3dAutoExpose autoExpose);

kVsFx(kStatus) kS3dAutoExpose_SetRoi(kS3dAutoExpose autoExpose, k32u viewIndex, k32u x, k32u y, k32u width, k32u height);
kVsFx(kStatus) kS3dAutoExpose_SetIterationLimit(kS3dAutoExpose autoExpose, k32u iterationLimit);
kVsFx(kStatus) kS3dAutoExpose_SetStepLimit(kS3dAutoExpose autoExpose, k32u stepLimit);
kVsFx(kStatus) kS3dAutoExpose_SetContrastThreshold(kS3dAutoExpose autoExpose, k32u threshold);
kVsFx(kStatus) kS3dAutoExpose_SetExposureThreshold(kS3dAutoExpose autoExpose, k32u threshold);

kVsFx(kStatus) kS3dAutoExpose_Update(kS3dAutoExpose autoExpose, kImage* whiteImages, kImage* blackImages, k32u currentExposure, k32u* nextExposure);
kVsFx(kS3dAutoExposeStatus)  kS3dAutoExpose_Status(kS3dAutoExpose autoExpose);

kVsFx(kStatus)   kS3dAutoExpose_Plot(kS3dAutoExpose autoExpose, kPlot* plot);

#endif /* #define LMITECH_KVISION_S3D_AUTOEXPOSE_H_INCLUDED */
