/** 
 * @file    kS3dBallArrayAlg.h
 * @brief   Declares the kS3dBallArrayAlg class. 
 *
 * @internal
 * Copyright (C) 2016-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef kVS_BALL_ARRAY_ALG_H
#define kVS_BALL_ARRAY_ALG_H

#include <kVision/Common/kVision.h>

#include <kApi/Data/kArray2.h>
#include <kApi/Data/kArrayList.h>

/**
 * @class       kS3dBallArrayAlg
 * @extends     kObject
 * @ingroup     kVision-S3d
 * @brief       TODO: write this
 */
typedef kObject kS3dBallArrayAlg;

/** 
 * Constructs a kS3dBallArrayAlg object.
 *
 * @public              @memberof kS3dBallArrayAlg
 * @param   alg  Destination for the constructed object handle.
 * @param   allocator   Memory allocator (or kNULL for default).
 * @return              Operation status. 
 */
kVsFx(kStatus) kS3dBallArrayAlg_Construct(kS3dBallArrayAlg* alg, kAlloc allocator);

/**
* Constructs a kS3dBallArrayAlg object.
*
* @public              @memberof kS3dBallArrayAlg
* @param   alg         Destination for the constructed object handle.
* @param   allocator   Memory allocator (or kNULL for default).
* @return              Operation status.
*/

kVsFx(kStatus) kS3dBallArrayAlg_Detect(kS3dBallArrayAlg alg, kArray2 points, k64f sphereRadius);

kVsFx(kSize) kS3dBallArrayAlg_BallCount(kS3dBallArrayAlg alg);

kVsFx(k64f) kS3dBallArrayAlg_Radius(kS3dBallArrayAlg alg, kSize index);

kVsFx(k64f) kS3dBallArrayAlg_Error(kS3dBallArrayAlg alg, kSize index);

kVsFx(kPoint3d64f) kS3dBallArrayAlg_Center(kS3dBallArrayAlg alg, kSize index);

kVsFx(k64f) kS3dBallArrayAlg_Coverage(kS3dBallArrayAlg alg, kSize index);

kVsFx(kSize) kS3dBallArrayAlg_PointCount(kS3dBallArrayAlg alg, kSize index); // total number of points used to estimate spheres.

kVsFx(k64f) kS3dBallArrayAlg_Distance(kS3dBallArrayAlg alg, kSize index0, kSize index1);


kVsFx(kPoint3d64f*) kS3dBallArrayAlg_CentersData(kS3dBallArrayAlg alg);
kVsFx(k64f*) kS3dBallArrayAlg_RadiusData(kS3dBallArrayAlg alg);
kVsFx(k64f*) kS3dBallArrayAlg_ErrorData(kS3dBallArrayAlg alg);
kVsFx(k64f*) kS3dBallArrayAlg_CoverageData(kS3dBallArrayAlg alg);

kVsFx(kStatus) kS3dBallArrayAlg_Pltot2d(kS3dBallArrayAlg alg, kPlot* plot);

// Support for legacy code of SPhereFinderV2 //
kVsFx(kStatus) kS3dBallArrayAlg_BoundingBox(kS3dBallArrayAlg alg, kSize index, kPoint32s* tL, kPoint32s* bR);
kVsFx(kStatus) kS3dBallArrayAlg_CopyZInBoundingBox(kS3dBallArrayAlg alg, k64f* z, kPoint32s* tL, kPoint32s* bR);

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

#include <kVision/S3d/kS3dBallArrayAlg.x.h>

#endif  /* kVS_BALL_ARRAY_ALG_H */
