/**
* @file    kS3dHuffmanCode.x.h
* @brief   Declares the kS3dHuffmanCode Class.
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc. All rights reserved.
*/

#ifndef KVISION_KS3D_HUFFMANN_X_H
#define KVISION_KS3D_HUFFMANN_X_H

typedef enum kS3dHuffmanItemIdent
{
    kM3DHUFFMANITEM_VERTEX_X = 1,
    kM3DHUFFMANITEM_VERTEX_Y = 2,
    kM3DHUFFMANITEM_VERTEX_Z = 3,

    kM3DHUFFMANITEM_FACET_NX = 4,
    kM3DHUFFMANITEM_FACET_NY = 5,
    kM3DHUFFMANITEM_FACET_NZ = 6,

    kM3DHUFFMANITEM_FACET_A = 7,
    kM3DHUFFMANITEM_FACET_B = 8,
    kM3DHUFFMANITEM_FACET_C = 9,
    kM3DHUFFMANITEM_FACET_D = 10,
    kM3DHUFFMANITEM_FACET_E = 17,
    kM3DHUFFMANITEM_FACET_F = 18,

    kM3DHUFFMANITEM_LINEINDEX_A = 11,
    kM3DHUFFMANITEM_LINEINDEX_B = 12,
    kM3DHUFFMANITEM_LINEINDEX_C = 13,

    kM3DHUFFMANITEM_POINTINDEX_A = 14,
    kM3DHUFFMANITEM_POINTINDEX_B = 15,


    kM3DHUFFMANITEM_IMAGE_VALID = 16,
    kM3DHUFFMANITEM_MATRIX_32S  = 17,
    kM3DHUFFMANITEM_POINT_CLOUD = 19,

    kM3DHUFFMANITEM_POINTMAP_R = 20,
    kM3DHUFFMANITEM_POINTMAP_G = 21,
    kM3DHUFFMANITEM_POINTMAP_B = 22,

    kM3DHUFFMANITEM_TEXTURE_U = 23,
    kM3DHUFFMANITEM_TEXTURE_V = 24,

    kM3DHUFFMANITEM_IMAGE_8BPP_GREYSCALE = 25,
    kM3DHUFFMANITEM_IMAGE_8BPP_CFA = 26,
    kM3DHUFFMANITEM_IMAGE_8BPC_BGRX = 27,
    kM3DHUFFMANITEM_IMAGE_JPG = 28,
    kM3DHUFFMANITEM_TEXTURE_IMAGE
}kS3dHuffmanItemIdent;


typedef struct kS3dHuffmanCodeClass
{
    kObjectClass base;
    kM3dHuffmanItemHeader header;
    kArray1 data;
    kArray1 buffer;
    kArray1 output;
    kArray1 histoTab;
    kArray1 codeTab;
}kS3dHuffmanCodeClass;

kDeclareClassEx(kVs, kS3dHuffmanCode, kObject)

kStatus kS3dHuffmanCode_Init(kS3dHuffmanCode huffmanCode, kType classType, kAlloc alloc);
kVsFx(kStatus) kS3dHuffmanCode_VRelease(kS3dHuffmanCode huffmanCode);
kStatus kS3dHuffmanCode_SumUpDataOnce(kS3dHuffmanCode huffmanCode);
kStatus kS3dHuffmanCode_SubDataOnce(kArray1 data, k32s count, k32s *size);
kStatus kS3dHuffmanCode_SubData(kS3dHuffmanCode huffmanCode);
k32u kS3dHuffmanCode_Encode(k32s X, k32u* Y, k16s* indexX, k16s* indexY);
k32s kS3dHuffmanCode_EncodeLength(k32s x);
k32s kS3dHuffmanCode_SetEncodeOutput(k8u* pData, k32s index, k16s*  bitIndex, k32u X, k32u Y, k16s bitZahlX, k16s bitZahlY);
kStatus kS3dHuffmanCode_SetDifferenceMap(k32s* pData, k16s* level, k16s lineLen, k16s lineCount);
k32s kS3dHuffmanCode_Decode(k8u* pData, k32s* index, k16s*  bitIndex);
kVsFx(kStatus) kS3dHuffmanCode_GetDifferenceMap(k32s* pData, k32s lineLen, k32s lineCount, k16s index);

#define kS3DHUFFMANCODE(HANDLE) ((kS3dHuffmanCodeClass*)HANDLE)

#endif  /* #ifndef KVISION_KS3D_HUFFMANN_X_H */
