/**
 * @file    ${filename_header_public}}
 * @brief   Declares the ${classname} class.
 *
 * @internal
 * Copyright (C) 2016-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef kVS_MONO_MERGE_LOCAL_ALG_H
#define kVS_MONO_MERGE_LOCAL_ALG_H

#include <kVision/Common/kVision.h>

//////////////////////////////////////////////////////////////////////////
// @class                    kS3dMonoMergeLocalAlg
// @extends                  kObject
// @ingroup                  kVision-S3d
// @brief                    Algorithm class for merging mono and stereo 
//                           meshes using local coordinates
//////////////////////////////////////////////////////////////////////////

typedef kObject kS3dMonoMergeLocalAlg;

///////////////////////////////////////////////////////////////////////////
// Constructs a kS3dMonoMergeAlg object.
//
// @public                   @memberof kS3dMonoMergeLocalAlg
// @param   alg              Destination for the constructed object handle.
// @param   allocator        Memory allocator (or kNULL for default).
// @return                   Operation status.
//////////////////////////////////////////////////////////////////////////

kVsFx(kStatus) kS3dMonoMergeLocalAlg_Construct(kS3dMonoMergeLocalAlg* mMerge, kAlloc allocator);

//////////////////////////////////////////////////////////////////////////
// Merge 2 mono and stereo meshes by applying a local reconstruction algorithm
//
// @public                   @memberof kS3dMonoMergeLocalAlg
// @param   alg              alg object
// @param   stereo           stereo point grid
// @param   mono0            left camera mono point grid
// @param   mono1            right camera mono point grid
// @param   mergeThreshold   threshold for determining how far to pull 
// @return                   Operation status.
//////////////////////////////////////////////////////////////////////////

kVsFx(kStatus) kS3dMonoMergeLocalAlg_Merge(kS3dMonoMergeLocalAlg alg, kArray2 stereo, kArray2 mono0, kArray2 mono1);

//////////////////////////////////////////////////////////////////////////
// Set merge threshold value. (10% viewport)
// Determines how far to pull stereo to mono during alignment.
//
// @public                   @memberof kS3dMonoMergeAlg
// @param   alg              alg object
// @param   mergeThreshold   threshold for determining how far to pull (10 % of FOV) default 0
// @return                   Operation status.
//////////////////////////////////////////////////////////////////////////

kInlineFx(kStatus) kS3dMonoMergeLocalAlg_SetMergeThreshold(kS3dMonoMergeLocalAlg alg, k32s mergeThreshold);

//////////////////////////////////////////////////////////////////////////
// Get merge threshold value. (10% viewport)
// Determines how far to pull stereo to mono during alignment.
//
// @public                   @memberof kS3dMonoMergeAlg
// @param   alg              alg object
// @return                   threshold for determining how far to pull (10 % of FOV) default 0
//////////////////////////////////////////////////////////////////////////

kInlineFx(k32s) kS3dMonoMergeLocalAlg_MergeThreshold(kS3dMonoMergeLocalAlg alg);

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

#include <kVision/S3d/kS3dMonoMergeLocalAlg.x.h>

#endif  /* kVS_MONO_MERGE_LOCAL_ALG_H */
