/**
 * @file    kS3dPhaseActionInfo.x.h
 *
 * @internal
 * Copyright (C) by LMI Technologies Inc. All rights reserved.
 */
#ifndef kS3D_PHASE_ACTION_INFO_X_H
#define kS3D_PHASE_ACTION_INFO_X_H

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

typedef struct kS3dPhaseActionInfoClass
{
    kObjectClass base;

    // Format and compression //
    kSize phaseDecoderFormat;          // kCameraPhaseDecoderFormat 
                                       //   [kCAMERA_PHASE_DECODER_FORMAT_I8P24 = 4, kCAMERA_PHASE_DECODER_FORMAT_DELTA_I8_P24 = 8, kCAMERA_PHASE_DECODER_FORMAT_DELTA_P24 = 16]
    kSize phasePrediction;             // for compression only 
                                       //   [kCAMERA_PHASE_DECODER_FORMAT_DELTA_I8_P24, kCAMERA_PHASE_DECODER_FORMAT_DELTA_P24]
    kSize subframeCount;               // for compression only

    kSize encodeType;                  // kS3dEncodeType [kS3D_ENCODE_TYPE_STRIPE = 0, kS3D_ENCODE_TYPE_EMBEDDED_PHASE = 1]
    kBool imageInputEnabled;           // overrides format and sets up for image capture

    // EPS //
    kSize embeddedPhasePeriodCount;
    kArray1 embeddedPhaseCoefficients; // k64f
    kArray1 embeddedPhaseImageCounts;  // kSize

    // Stripe //
    k64f periodLength;
    kSize referenceStepCount;
    kSize stripeStepCount;
    kSize phaseStepCount;

    // Common //
    k64f stripeIntensity;
    k64f phaseIntensity;
    k64f patternUniformity;

    kSize phasePeriod;
    kSize stripeThreshold;
    kSize phaseThreshold;

} kS3dPhaseActionInfoClass;

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

kDeclareClassEx(kVs, kS3dPhaseActionInfo, kObject)

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

kVsFx(kStatus) kS3dPhaseActionInfo_Init(kS3dPhaseActionInfo info, kType type, kAlloc alloc);
kVsFx(kStatus) kS3dPhaseActionInfo_VRelease(kS3dPhaseActionInfo info);

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

#endif // kS3D_PHASE_ACTION_INFO_X_H
