/**
* @file    kS3dPhaseOutlier.h
* @brief   Declares the kS3dPhaseOutlier class. 
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc. All rights reserved.
*/

#ifndef kS3D_kS3DPHASEOUTLIER_H
#define kS3D_kS3DPHASEOUTLIER_H

#include <kVision/Common/kVision.h>
#include <kVision/S3d/kS3dCommon.h>

/**
* @class       kS3dPhaseOutlier
* @extends     kObject
* @ingroup     kVision-S3d
* @brief       Performs filtering operation of outlier points on phase map according to 3 sigma principe within 5 x 5 pixel area.
*              Only the points with deviation larger than the tolerance will be corrected.
*/
typedef kObject kS3dPhaseOutlier;

/**
* Constructs a kS3dPhaseOutlier object
*
* @public              @memberof kS3dPhaseOutlier
* @param   outlier     Destination for the constructed object handle.
* @param   allocator   Memory allocator (or kNULL for default).
* @return              Operation status.
*/
kVsFx(kStatus) kS3dPhaseOutlier_Construct(kS3dPhaseOutlier* outlier, kAlloc allocator);

/**
*  Runs the filtering operation of outlier points.
*
* @public              @memberof kS3dPhaseOutlier
* @param   outlier     kS3dPhaseOutlier object.
* @param   data        Phase map of kArray2 <k32s>. The both width and height of the array should be larger than 8 pixel.
* @param   back        Backup of the original phase map for comparison. kArray2 <k32s> 
*                      The both width and height of the array should be identical to the phase map array.   
* @param   temp        Temporary data buffer for the operation. kArray2 <k32s> 
*                      The both width and height of the array should be identical to the phase map array.   
* @return              Operation status.
*/
kVsFx(kStatus) kS3dPhaseOutlier_Run(kS3dPhaseOutlier outlier, kArray2 data, kArray2 back, kArray2 temp, kArray2 valid);

#include <kVision/S3d/kS3dPhaseOutlier.x.h>

#endif
