#ifndef kS3D_PHASE_PACK_BLOCK_X_H
#define kS3D_PHASE_PACK_BLOCK_X_H

#include <kVision/S3d/kS3dPhasePackBlock.h>
#include <kVision/S3d/kS3dPhasePackBlockInfo.h>
#include <kVision/S3d/kS3dPhaseProcessor.h>
#include <kVision/S3d/kS3dStereoCal.h>
#include <kFireSync/Data/kMsg.h>
#include <kFireSync/Pipe/kPxPort.h>

#define kS3D_PHASE_PACK_BLOCK_DESCRIPTION    "kPhasePixel splitter/combiner block"


typedef struct kS3dPhasePackBlockClass
{
    kPxBlockClass base;
    kBool splitOperation;

    kPort portCombined;
    kPort portPhaseOffset;
    kPort portIntensity;
    kPort portContrast;

    kBool forwardIntensity;
    kBool forwardContrast;

    kMsg combineInputPhaseOffset;
    kMsg combineInputIntensity;
    kMsg combineInputContrast;

} kS3dPhasePackBlockClass;

kDeclareClassEx(kVs, kS3dPhasePackBlock, kPxBlock)

kVsFx(const kChar*) kS3dPhasePackBlock_VDescription();
kVsFx(kStatus) kS3dPhasePackBlock_VOnSetup(kS3dPhasePackBlock block);
kVsFx(kStatus) kS3dPhasePackBlock_VOnStart(kS3dPhasePackBlock block);
kVsFx(kStatus) kS3dPhasePackBlock_VOnPause(kS3dPhasePackBlock block);
kVsFx(kStatus) kS3dPhasePackBlock_VOnResume(kS3dPhasePackBlock block);
kVsFx(kStatus) kS3dPhasePackBlock_VOnStop(kS3dPhasePackBlock block);
kVsFx(kStatus) kS3dPhasePackBlock_VOnReceive(kS3dPhasePackBlock block, kPxPort port, kMsgSet msg);

kStatus kS3dPhasePackBlock_ConfigureDefaults(kS3dPhasePackBlockInfo info);
kStatus kS3dPhasePackBlock_Validate(kS3dPhasePackBlockInfo info);

kStatus kS3dPhasePackBlock_Unpack(kS3dPhasePackBlock block, kArray2 inCombined, kArray2 outPhaseOffset, kArray2 outIntensity, kArray2 outContrast);
kStatus kS3dPhasePackBlock_Pack(kS3dPhasePackBlock block, kArray2 inPhaseOffset, kArray2 inIntensity, kArray2 inContrast, kArray2 outCombined);

kStatus kS3dPhasePackBlock_SplitReceive(kS3dPhasePackBlock block, kPxPort port, kMsgSet msg);
kStatus kS3dPhasePackBlock_CombineReceive(kS3dPhasePackBlock block, kPxPort port, kMsgSet msg);

#endif
