/**
* @file    kS3dPhasePackBlockInfo.h
* @brief   Declares the kS3dPhasePackBlockInfo class.
*
* @internal
* Copyright (C) 2014-2022 by LMI Technologies Inc. All rights reserved.
*/
#ifndef kS3D_PHASE_PACK_BLOCK_INFO_H
#define kS3D_PHASE_PACK_BLOCK_INFO_H

#include <kVision/Common/kVision.h>
#include <kApi/Data/kXml.h>
#include <kVision/L3d/kL3dTransform3d.h>

#define kS3D_PHASE_PACK_BLOCK_NAME                      "PhasePack"
#define kS3D_PHASE_PACK_BLOCK_TYPE_NAME                 "PhasePack"

#define kS3D_PHASE_PACK_BLOCK_IN_COMBINED_NAME          "InCombined"
#define kS3D_PHASE_PACK_BLOCK_OUT_COMBINED_NAME         "OutCombined"

#define kS3D_PHASE_PACK_BLOCK_IN_PHASE_OFFSET_NAME      "InPhaseOffset"
#define kS3D_PHASE_PACK_BLOCK_OUT_PHASE_OFFSET_NAME     "OutPhaseOffset"

#define kS3D_PHASE_PACK_BLOCK_IN_INTENSITY_NAME         "InIntensity"
#define kS3D_PHASE_PACK_BLOCK_OUT_INTENSITY_NAME        "OutIntensity"

#define kS3D_PHASE_PACK_BLOCK_IN_CONTRAST_NAME          "InContrast"
#define kS3D_PHASE_PACK_BLOCK_OUT_CONTRAST_NAME         "OutContrast"

typedef enum
{
    kS3D_PHASE_PACK_BLOCK_IN_COMBINED = 0,
    kS3D_PHASE_PACK_BLOCK_OUT_PHASE_OFFSET = 1,
    kS3D_PHASE_PACK_BLOCK_OUT_INTENSITY = 2,
    kS3D_PHASE_PACK_BLOCK_OUT_CONTRAST = 3,

    kS3D_PHASE_PACK_BLOCK_OUT_COMBINED = 100,
    kS3D_PHASE_PACK_BLOCK_IN_PHASE_OFFSET = 101,
    kS3D_PHASE_PACK_BLOCK_IN_INTENSITY = 102,
    kS3D_PHASE_PACK_BLOCK_IN_CONTRAST = 103

} kS3dPhasePackBlockPort;

/**
* @class   kS3dPhasePackBlockInfo
* @ingroup kVision
* @brief   Settings class for kS3dPhasePackBlock
*
* The block is used to split or combine 2-dimensional arrays of kPhasePixel values to or from individual fields. In transmitting
* phase data over network the sender can use an instance of the block configured to split, while the receiver would be configured 
* to combine. Data unused in the processing by the receiver should not be routed to minimize unnecessary transmission
*
*/
typedef kObject kS3dPhasePackBlockInfo;

/**
* Constructs a kS3dPhasePackBlockInfo object
*
* @public              @memberof kS3dPhasePackBlockInfo
* @param   info        Destination for the constructed object handle.
* @param   allocator   Memory allocator (or kNULL for default).
* @return              Operation status.
*/
kVsFx(kStatus) kS3dPhasePackBlockInfo_Construct(kS3dPhasePackBlockInfo* info, kAlloc allocator);

/**
* Reads values from a kXml object
*
* @public              @memberof kS3dPhasePackBlockInfo
* @param   info        Info object.
* @param   xml         Source kXml object
* @param   item        Root xml node
* @return              Operation status.
*/
kVsFx(kStatus) kS3dPhasePackBlockInfo_Read(kS3dPhasePackBlockInfo info, kXml xml, kXmlItem item);

/**
* Writes values to a kXml object
*
* @public              @memberof kS3dPhasePackBlockInfo
* @param   info        Info object.
* @param   xml         destination kXml object
* @param   item        Root xml node
* @return              Operation status.
*/
kVsFx(kStatus) kS3dPhasePackBlockInfo_Write(kS3dPhasePackBlockInfo info, kXml xml, kXmlItem item);

/**
* Loads a new kS3dPhasePackBlockInfo from a kXml object
*
* @public              @memberof kS3dPhasePackBlockInfo
* @param   info        Destination for the constructed object handle.
* @param   xml         Source kXml object
* @param   allocator   Memory allocator (or kNULL for default).
* @return              Operation status.
*/
kVsFx(kStatus) kS3dPhasePackBlockInfo_Load(kS3dPhasePackBlockInfo* info, kXml xml, kAlloc allocator);

/**
* Saves a kS3dPhasePackBlockInfo to a new kXml object
*
* @public              @memberof kS3dPhasePackBlockInfo
* @param   info        Object to be saved
* @param   xml         Pointer to a destination kXml handle.
* @param   allocator   Memory allocator (or kNULL for default).
* @return              Operation status.
*/
kVsFx(kStatus) kS3dPhasePackBlockInfo_Save(kS3dPhasePackBlockInfo info, kXml* xml, kAlloc allocator);

/**
* Specify whether the block should operate as a splitter or a combiner.  
*
* @public              @memberof kS3dPhasePackBlockInfo
* @param   info        Object to be saved
* @param   split       Flag specifying whether the block should operate as a splitter. 
* @return              Operation status.
*/
kVsFx(kStatus) kS3dPhasePackBlockInfo_EnableSplitOperation(kS3dPhasePackBlockInfo info, kBool split);

/**
* Query whether the block should operate as a splitter or a combiner. 
*
* @public              @memberof kS3dPhasePackBlockInfo
* @param   info        Object to be saved
* @return              Flag specifying whether the block is operating as a splitter. 
*/
kVsFx(kBool) kS3dPhasePackBlockInfo_SplitOperationEnabled(kS3dPhasePackBlockInfo info);

#include <kVision/S3d/kS3dPhasePackBlockInfo.x.h>

#endif
